/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.Avatar;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeCreateBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeUpdateBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueTypesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<IssueTypeDetails> returnType_createIssueType = new TypeReference<IssueTypeDetails>(){};
    private static final TypeReference<Avatar> returnType_createIssueTypeAvatar = new TypeReference<Avatar>(){};
    private static final TypeReference<List<IssueTypeDetails>> returnType_getAlternativeIssueTypes = new TypeReference<List<IssueTypeDetails>>(){};
    private static final TypeReference<List<IssueTypeDetails>> returnType_getIssueAllTypes = new TypeReference<List<IssueTypeDetails>>(){};
    private static final TypeReference<IssueTypeDetails> returnType_getIssueType = new TypeReference<IssueTypeDetails>(){};
    private static final TypeReference<IssueTypeDetails> returnType_updateIssueType = new TypeReference<IssueTypeDetails>(){};
    private final RestClient restClient;

    public IssueTypesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<IssueTypeDetails> createIssueType(IssueTypeCreateBean issueTypeCreateBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeCreateBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueType);
    }

    public Single<Avatar> createIssueTypeAvatar(String id, Integer size, Object body, Optional<Integer> x, Optional<Integer> y, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype/{id}/avatar2");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (x.isPresent()) {
            queryParams.put("x", Collections.singleton(String.valueOf(x.get())));
        }
        if (y.isPresent()) {
            queryParams.put("y", Collections.singleton(String.valueOf(y.get())));
        }
        queryParams.put("size", Collections.singleton(String.valueOf(size)));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssueTypeAvatar);
    }

    public Completable deleteIssueType(String id, Optional<String> alternativeIssueTypeId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (alternativeIssueTypeId.isPresent()) {
            queryParams.put("alternativeIssueTypeId", Collections.singleton(String.valueOf(alternativeIssueTypeId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<List<IssueTypeDetails>> getAlternativeIssueTypes(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype/{id}/alternatives");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAlternativeIssueTypes);
    }

    public Single<List<IssueTypeDetails>> getIssueAllTypes(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueAllTypes);
    }

    public Single<IssueTypeDetails> getIssueType(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueType);
    }

    public Single<IssueTypeDetails> updateIssueType(String id, IssueTypeUpdateBean issueTypeUpdateBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issuetype/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(issueTypeUpdateBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateIssueType);
    }
}

