/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueLink;
import org.everit.atlassian.restclient.jiracloud.v3.model.LinkIssueRequestJsonBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueLinksApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<IssueLink> returnType_getIssueLink = new TypeReference<IssueLink>(){};
    private static final TypeReference<Object> returnType_linkIssues = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueLinksApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable deleteIssueLink(String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issueLink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<IssueLink> getIssueLink(String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issueLink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueLink);
    }

    public Single<Object> linkIssues(LinkIssueRequestJsonBean linkIssueRequestJsonBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issueLink");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(linkIssueRequestJsonBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_linkIssues);
    }
}

