/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanChangelog;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueChangelogApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<PageBeanChangelog> returnType_getChangeLogs = new TypeReference<PageBeanChangelog>(){};
    private final RestClient restClient;

    public IssueChangelogApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<PageBeanChangelog> getChangeLogs(String issueIdOrKey, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/issue/{issueIdOrKey}/changelog");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getChangeLogs);
    }
}

