/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.Avatar;
import org.everit.atlassian.restclient.jiracloud.v3.model.Avatars;
import org.everit.atlassian.restclient.jiracloud.v3.model.SystemAvatars;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class AvatarsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<SystemAvatars> returnType_getAllSystemAvatars = new TypeReference<SystemAvatars>(){};
    private static final TypeReference<Avatars> returnType_getAvatars = new TypeReference<Avatars>(){};
    private static final TypeReference<Avatar> returnType_storeAvatar = new TypeReference<Avatar>(){};
    private final RestClient restClient;

    public AvatarsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable deleteAvatar(String type, String owningObjectId, Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/universal_avatar/type/{type}/owner/{owningObjectId}/avatar/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("type", String.valueOf(type));
        pathParams.put("owningObjectId", String.valueOf(owningObjectId));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<SystemAvatars> getAllSystemAvatars(String type, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/avatar/{type}/system");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("type", String.valueOf(type));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllSystemAvatars);
    }

    public Single<Avatars> getAvatars(String type, String entityId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/universal_avatar/type/{type}/owner/{entityId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("type", String.valueOf(type));
        pathParams.put("entityId", String.valueOf(entityId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAvatars);
    }

    public Single<Avatar> storeAvatar(String type, String entityId, Integer size, Object body, Optional<Integer> x, Optional<Integer> y, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/universal_avatar/type/{type}/owner/{entityId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("type", String.valueOf(type));
        pathParams.put("entityId", String.valueOf(entityId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (x.isPresent()) {
            queryParams.put("x", Collections.singleton(String.valueOf(x.get())));
        }
        if (y.isPresent()) {
            queryParams.put("y", Collections.singleton(String.valueOf(y.get())));
        }
        queryParams.put("size", Collections.singleton(String.valueOf(size)));
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_storeAvatar);
    }
}

