/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserPickerUser;

@ApiModel(description="The list of users found in a search, including header text (Showing X of Y matching users) and total of matched users.")
public class FoundUsers {
    @JsonProperty(value="users")
    private List<UserPickerUser> users = new ArrayList<UserPickerUser>();
    @JsonProperty(value="total")
    private Integer total;
    @JsonProperty(value="header")
    private String header;

    public FoundUsers users(List<UserPickerUser> users) {
        this.users = users;
        return this;
    }

    public FoundUsers addUsersItem(UserPickerUser usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<UserPickerUser>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<UserPickerUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserPickerUser> users) {
        this.users = users;
    }

    public FoundUsers total(Integer total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total number of users found in the search.")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public FoundUsers header(String header) {
        this.header = header;
        return this;
    }

    @ApiModelProperty(value="Header text indicating the number of users in the response and the total number of users found in the search.")
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoundUsers foundUsers = (FoundUsers)o;
        return Objects.equals(this.users, foundUsers.users) && Objects.equals(this.total, foundUsers.total) && Objects.equals(this.header, foundUsers.header);
    }

    public int hashCode() {
        return Objects.hash(this.users, this.total, this.header);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FoundUsers {\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

