/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about a failed webhook.")
public class FailedWebhook {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="body")
    private String body;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="failureTime")
    private Long failureTime;

    public FailedWebhook id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The webhook ID, as sent in the `X-Atlassian-Webhook-Identifier` header with the webhook.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FailedWebhook body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(value="The webhook body.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public FailedWebhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="The original webhook destination.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FailedWebhook failureTime(Long failureTime) {
        this.failureTime = failureTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The time the webhook was added to the list of failed webhooks (that is, the time of the last failed retry).")
    public Long getFailureTime() {
        return this.failureTime;
    }

    public void setFailureTime(Long failureTime) {
        this.failureTime = failureTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedWebhook failedWebhook = (FailedWebhook)o;
        return Objects.equals(this.id, failedWebhook.id) && Objects.equals(this.body, failedWebhook.body) && Objects.equals(this.url, failedWebhook.url) && Objects.equals(this.failureTime, failedWebhook.failureTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.body, this.url, this.failureTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FailedWebhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    failureTime: ").append(this.toIndentedString(this.failureTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

