/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.SharePermission;
import org.everit.atlassian.restclient.jiracloud.v2.model.UserBean;

@ApiModel(description="Details of a dashboard.")
public class Dashboard {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="isFavourite")
    private Boolean isFavourite;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private UserBean owner;
    @JsonProperty(value="popularity")
    private Long popularity;
    @JsonProperty(value="rank")
    private Integer rank;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="sharePermissions")
    private List<SharePermission> sharePermissions = new ArrayList<SharePermission>();
    @JsonProperty(value="view")
    private String view;

    public Dashboard description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The ID of the dashboard.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Whether the dashboard is selected as a favorite by the user.")
    public Boolean getIsFavourite() {
        return this.isFavourite;
    }

    @ApiModelProperty(value="The name of the dashboard.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The owner of the dashboard.")
    public UserBean getOwner() {
        return this.owner;
    }

    @ApiModelProperty(value="The number of users who have this dashboard as a favorite.")
    public Long getPopularity() {
        return this.popularity;
    }

    @ApiModelProperty(value="The rank of this dashboard.")
    public Integer getRank() {
        return this.rank;
    }

    @ApiModelProperty(value="The URL of these dashboard details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The details of any share permissions for the dashboard.")
    public List<SharePermission> getSharePermissions() {
        return this.sharePermissions;
    }

    @ApiModelProperty(value="The URL of the dashboard.")
    public String getView() {
        return this.view;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dashboard dashboard = (Dashboard)o;
        return Objects.equals(this.description, dashboard.description) && Objects.equals(this.id, dashboard.id) && Objects.equals(this.isFavourite, dashboard.isFavourite) && Objects.equals(this.name, dashboard.name) && Objects.equals(this.owner, dashboard.owner) && Objects.equals(this.popularity, dashboard.popularity) && Objects.equals(this.rank, dashboard.rank) && Objects.equals(this.self, dashboard.self) && Objects.equals(this.sharePermissions, dashboard.sharePermissions) && Objects.equals(this.view, dashboard.view);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.isFavourite, this.name, this.owner, this.popularity, this.rank, this.self, this.sharePermissions, this.view);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dashboard {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isFavourite: ").append(this.toIndentedString(this.isFavourite)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    popularity: ").append(this.toIndentedString(this.popularity)).append("\n");
        sb.append("    rank: ").append(this.toIndentedString(this.rank)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    sharePermissions: ").append(this.toIndentedString(this.sharePermissions)).append("\n");
        sb.append("    view: ").append(this.toIndentedString(this.view)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

