/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.DeleteAndReplaceVersionBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Version;
import org.everit.atlassian.restclient.jiracloud.v2.model.VersionIssueCounts;
import org.everit.atlassian.restclient.jiracloud.v2.model.VersionMoveBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.VersionUnresolvedIssuesCount;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class VersionApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<Version> returnType_createVersion = new TypeReference<Version>(){};
    private static final TypeReference<Object> returnType_deleteAndReplaceVersion = new TypeReference<Object>(){};
    private static final TypeReference<Version> returnType_getVersion = new TypeReference<Version>(){};
    private static final TypeReference<VersionIssueCounts> returnType_getVersionRelatedIssues = new TypeReference<VersionIssueCounts>(){};
    private static final TypeReference<VersionUnresolvedIssuesCount> returnType_getVersionUnresolvedIssues = new TypeReference<VersionUnresolvedIssuesCount>(){};
    private static final TypeReference<Object> returnType_mergeVersions = new TypeReference<Object>(){};
    private static final TypeReference<Version> returnType_moveVersion = new TypeReference<Version>(){};
    private static final TypeReference<Version> returnType_updateVersion = new TypeReference<Version>(){};
    private final RestClient restClient;

    public VersionApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Version> createVersion(Version version, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(version));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createVersion);
    }

    public Single<Object> deleteAndReplaceVersion(String id, DeleteAndReplaceVersionBean deleteAndReplaceVersionBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}/removeAndSwap");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(deleteAndReplaceVersionBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_deleteAndReplaceVersion);
    }

    @Deprecated
    public Completable deleteVersion(String id, Optional<String> moveFixIssuesTo, Optional<String> moveAffectedIssuesTo, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (moveFixIssuesTo.isPresent()) {
            queryParams.put("moveFixIssuesTo", Collections.singleton(String.valueOf(moveFixIssuesTo.get())));
        }
        if (moveAffectedIssuesTo.isPresent()) {
            queryParams.put("moveAffectedIssuesTo", Collections.singleton(String.valueOf(moveAffectedIssuesTo.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Version> getVersion(String id, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getVersion);
    }

    public Single<VersionIssueCounts> getVersionRelatedIssues(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}/relatedIssueCounts");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getVersionRelatedIssues);
    }

    public Single<VersionUnresolvedIssuesCount> getVersionUnresolvedIssues(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}/unresolvedIssueCount");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getVersionUnresolvedIssues);
    }

    public Single<Object> mergeVersions(String id, String moveIssuesTo, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}/mergeto/{moveIssuesTo}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        pathParams.put("moveIssuesTo", String.valueOf(moveIssuesTo));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_mergeVersions);
    }

    public Single<Version> moveVersion(String id, VersionMoveBean versionMoveBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}/move");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(versionMoveBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveVersion);
    }

    public Single<Version> updateVersion(String id, Version version, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/version/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(version));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateVersion);
    }
}

