/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreatedIssue;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreatedIssues;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueCreateMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueUpdateDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueUpdateMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssuesUpdateBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Notification;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanChangelog;
import org.everit.atlassian.restclient.jiracloud.v2.model.Transitions;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssuesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Object> returnType_assignIssue = new TypeReference<Object>(){};
    private static final TypeReference<CreatedIssue> returnType_createIssue = new TypeReference<CreatedIssue>(){};
    private static final TypeReference<CreatedIssues> returnType_createIssues = new TypeReference<CreatedIssues>(){};
    private static final TypeReference<Object> returnType_doTransition = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_editIssue = new TypeReference<Object>(){};
    private static final TypeReference<PageBeanChangelog> returnType_getChangeLogs = new TypeReference<PageBeanChangelog>(){};
    private static final TypeReference<IssueCreateMetadata> returnType_getCreateIssueMeta = new TypeReference<IssueCreateMetadata>(){};
    private static final TypeReference<IssueUpdateMetadata> returnType_getEditIssueMeta = new TypeReference<IssueUpdateMetadata>(){};
    private static final TypeReference<IssueBean> returnType_getIssue = new TypeReference<IssueBean>(){};
    private static final TypeReference<Transitions> returnType_getTransitions = new TypeReference<Transitions>(){};
    private static final TypeReference<Object> returnType_notify = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssuesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> assignIssue(String issueIdOrKey, User user, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/assignee");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(user));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignIssue);
    }

    public Single<CreatedIssue> createIssue(IssueUpdateDetails requestBody, Optional<Boolean> updateHistory, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (updateHistory.isPresent()) {
            queryParams.put("updateHistory", Collections.singleton(String.valueOf(updateHistory.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssue);
    }

    public Single<CreatedIssues> createIssues(IssuesUpdateBean requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/bulk");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssues);
    }

    public Completable deleteIssue(String issueIdOrKey, Optional<String> deleteSubtasks, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (deleteSubtasks.isPresent()) {
            queryParams.put("deleteSubtasks", Collections.singleton(String.valueOf(deleteSubtasks.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Object> doTransition(String issueIdOrKey, IssueUpdateDetails requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/transitions");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_doTransition);
    }

    public Single<Object> editIssue(String issueIdOrKey, IssueUpdateDetails requestBody, Optional<Boolean> notifyUsers, Optional<Boolean> overrideScreenSecurity, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (notifyUsers.isPresent()) {
            queryParams.put("notifyUsers", Collections.singleton(String.valueOf(notifyUsers.get())));
        }
        if (overrideScreenSecurity.isPresent()) {
            queryParams.put("overrideScreenSecurity", Collections.singleton(String.valueOf(overrideScreenSecurity.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_editIssue);
    }

    public Single<PageBeanChangelog> getChangeLogs(String issueIdOrKey, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/changelog");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getChangeLogs);
    }

    public Single<IssueCreateMetadata> getCreateIssueMeta(Optional<List<String>> projectIds, Optional<List<String>> projectKeys, Optional<List<String>> issuetypeIds, Optional<List<String>> issuetypeNames, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/createmeta");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (projectIds.isPresent()) {
            queryParams.put("projectIds", RestClientUtil.objectCollectionToStringCollection((Collection)projectIds.get()));
        }
        if (projectKeys.isPresent()) {
            queryParams.put("projectKeys", RestClientUtil.objectCollectionToStringCollection((Collection)projectKeys.get()));
        }
        if (issuetypeIds.isPresent()) {
            queryParams.put("issuetypeIds", RestClientUtil.objectCollectionToStringCollection((Collection)issuetypeIds.get()));
        }
        if (issuetypeNames.isPresent()) {
            queryParams.put("issuetypeNames", RestClientUtil.objectCollectionToStringCollection((Collection)issuetypeNames.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getCreateIssueMeta);
    }

    public Single<IssueUpdateMetadata> getEditIssueMeta(String issueIdOrKey, Optional<Boolean> overrideScreenSecurity, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/editmeta");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (overrideScreenSecurity.isPresent()) {
            queryParams.put("overrideScreenSecurity", Collections.singleton(String.valueOf(overrideScreenSecurity.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getEditIssueMeta);
    }

    public Single<IssueBean> getIssue(String issueIdOrKey, Optional<List<String>> fields, Optional<Boolean> fieldsByKeys, Optional<String> expand, Optional<List<String>> properties, Optional<Boolean> updateHistory, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (fields.isPresent()) {
            queryParams.put("fields", RestClientUtil.objectCollectionToStringCollection((Collection)fields.get()));
        }
        if (fieldsByKeys.isPresent()) {
            queryParams.put("fieldsByKeys", Collections.singleton(String.valueOf(fieldsByKeys.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        if (updateHistory.isPresent()) {
            queryParams.put("updateHistory", Collections.singleton(String.valueOf(updateHistory.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssue);
    }

    public Single<Transitions> getTransitions(String issueIdOrKey, Optional<String> expand, Optional<String> transitionId, Optional<Boolean> skipRemoteOnlyCondition, Optional<Boolean> includeUnavailableTransitions, Optional<Boolean> sortByOpsBarAndStatus, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/transitions");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (transitionId.isPresent()) {
            queryParams.put("transitionId", Collections.singleton(String.valueOf(transitionId.get())));
        }
        if (skipRemoteOnlyCondition.isPresent()) {
            queryParams.put("skipRemoteOnlyCondition", Collections.singleton(String.valueOf(skipRemoteOnlyCondition.get())));
        }
        if (includeUnavailableTransitions.isPresent()) {
            queryParams.put("includeUnavailableTransitions", Collections.singleton(String.valueOf(includeUnavailableTransitions.get())));
        }
        if (sortByOpsBarAndStatus.isPresent()) {
            queryParams.put("sortByOpsBarAndStatus", Collections.singleton(String.valueOf(sortByOpsBarAndStatus.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getTransitions);
    }

    public Single<Object> notify(String issueIdOrKey, Notification requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/notify");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_notify);
    }
}

