/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeInfo;

/**
 * Details of an issue type hierarchy level.
 */
@ApiModel(description = "Details of an issue type hierarchy level.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-10-28T14:12:34.799+01:00[Europe/Prague]")
public class ProjectIssueTypesHierarchyLevel {
  @JsonProperty("entityId")
  private UUID entityId;

  @JsonProperty("level")
  private Integer level;

  @JsonProperty("name")
  private String name;

  @JsonProperty("issueTypes")
  private List<IssueTypeInfo> issueTypes = new ArrayList<>();

   /**
   * The ID of the issue type hierarchy level.
   * @return entityId
  **/
  @ApiModelProperty(value = "The ID of the issue type hierarchy level.")
  public UUID getEntityId() {
    return entityId;
  }

   /**
   * The level of the issue type hierarchy level.
   * @return level
  **/
  @ApiModelProperty(value = "The level of the issue type hierarchy level.")
  public Integer getLevel() {
    return level;
  }

   /**
   * The name of the issue type hierarchy level.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the issue type hierarchy level.")
  public String getName() {
    return name;
  }

   /**
   * The list of issue types in the hierarchy level.
   * @return issueTypes
  **/
  @ApiModelProperty(value = "The list of issue types in the hierarchy level.")
  public List<IssueTypeInfo> getIssueTypes() {
    return issueTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectIssueTypesHierarchyLevel projectIssueTypesHierarchyLevel = (ProjectIssueTypesHierarchyLevel) o;
    return Objects.equals(this.entityId, projectIssueTypesHierarchyLevel.entityId) &&
        Objects.equals(this.level, projectIssueTypesHierarchyLevel.level) &&
        Objects.equals(this.name, projectIssueTypesHierarchyLevel.name) &&
        Objects.equals(this.issueTypes, projectIssueTypesHierarchyLevel.issueTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entityId, level, name, issueTypes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectIssueTypesHierarchyLevel {\n");
    
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    issueTypes: ").append(toIndentedString(issueTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

