/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchRequestBean {
    @JsonProperty(value="jql")
    private String jql;
    @JsonProperty(value="startAt")
    private Integer startAt;
    @JsonProperty(value="maxResults")
    private Integer maxResults = 50;
    @JsonProperty(value="fields")
    private List<String> fields = new ArrayList<String>();
    @JsonProperty(value="validateQuery")
    private ValidateQueryEnum validateQuery;
    @JsonProperty(value="expand")
    private List<String> expand = new ArrayList<String>();
    @JsonProperty(value="properties")
    private List<String> properties = new ArrayList<String>();
    @JsonProperty(value="fieldsByKeys")
    private Boolean fieldsByKeys;

    public SearchRequestBean jql(String jql) {
        this.jql = jql;
        return this;
    }

    @ApiModelProperty(value="A [JQL](https://confluence.atlassian.com/x/egORLQ) expression.")
    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public SearchRequestBean startAt(Integer startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(value="The index of the first item to return in the page of results (page offset). The base index is `0`.")
    public Integer getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Integer startAt) {
        this.startAt = startAt;
    }

    public SearchRequestBean maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @ApiModelProperty(value="The maximum number of items to return per page.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public SearchRequestBean fields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public SearchRequestBean addFieldsItem(String fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:   *  `*all` Returns all fields.  *  `*navigable` Returns navigable fields.  *  Any issue field, prefixed with a minus to exclude.  The default is `*navigable`.  Examples:   *  `summary,comment` Returns the summary and comments fields only.  *  `-description` Returns all navigable (default) fields except description.  *  `*all,-comment` Returns all fields except comments.  Multiple `fields` parameters can be included in a request.  Note: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.")
    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public SearchRequestBean validateQuery(ValidateQueryEnum validateQuery) {
        this.validateQuery = validateQuery;
        return this;
    }

    @ApiModelProperty(value="Determines how to validate the JQL query and treat the validation results. Supported values:   *  `strict` Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).  *  `warn` Returns all errors as warnings.  *  `none` No validation is performed.  *  `true` *Deprecated* A legacy synonym for `strict`.  *  `false` *Deprecated* A legacy synonym for `warn`.  The default is `strict`.  Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the `validateQuery` value.")
    public ValidateQueryEnum getValidateQuery() {
        return this.validateQuery;
    }

    public void setValidateQuery(ValidateQueryEnum validateQuery) {
        this.validateQuery = validateQuery;
    }

    public SearchRequestBean expand(List<String> expand) {
        this.expand = expand;
        return this;
    }

    public SearchRequestBean addExpandItem(String expandItem) {
        if (this.expand == null) {
            this.expand = new ArrayList<String>();
        }
        this.expand.add(expandItem);
        return this;
    }

    @ApiModelProperty(value="Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:   *  `renderedFields` Returns field values rendered in HTML format.  *  `names` Returns the display name of each field.  *  `schema` Returns the schema describing a field type.  *  `transitions` Returns all possible transitions for the issue.  *  `operations` Returns all possible operations for the issue.  *  `editmeta` Returns information about how each field can be edited.  *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.  *  `versionedRepresentations` Instead of `fields`, returns `versionedRepresentations` a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.")
    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public SearchRequestBean properties(List<String> properties) {
        this.properties = properties;
        return this;
    }

    public SearchRequestBean addPropertiesItem(String propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.")
    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public SearchRequestBean fieldsByKeys(Boolean fieldsByKeys) {
        this.fieldsByKeys = fieldsByKeys;
        return this;
    }

    @ApiModelProperty(value="Reference fields by their key (rather than ID). The default is `false`.")
    public Boolean getFieldsByKeys() {
        return this.fieldsByKeys;
    }

    public void setFieldsByKeys(Boolean fieldsByKeys) {
        this.fieldsByKeys = fieldsByKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequestBean searchRequestBean = (SearchRequestBean)o;
        return Objects.equals(this.jql, searchRequestBean.jql) && Objects.equals(this.startAt, searchRequestBean.startAt) && Objects.equals(this.maxResults, searchRequestBean.maxResults) && Objects.equals(this.fields, searchRequestBean.fields) && Objects.equals((Object)this.validateQuery, (Object)searchRequestBean.validateQuery) && Objects.equals(this.expand, searchRequestBean.expand) && Objects.equals(this.properties, searchRequestBean.properties) && Objects.equals(this.fieldsByKeys, searchRequestBean.fieldsByKeys);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jql, this.startAt, this.maxResults, this.fields, this.validateQuery, this.expand, this.properties, this.fieldsByKeys});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchRequestBean {\n");
        sb.append("    jql: ").append(this.toIndentedString(this.jql)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    validateQuery: ").append(this.toIndentedString((Object)this.validateQuery)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    fieldsByKeys: ").append(this.toIndentedString(this.fieldsByKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValidateQueryEnum {
        STRICT("strict"),
        WARN("warn"),
        NONE("none"),
        TRUE("true"),
        FALSE("false");

        private String value;

        private ValidateQueryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValidateQueryEnum fromValue(String value) {
            for (ValidateQueryEnum b : ValidateQueryEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

