/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class IssueTypeCreateBean {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="type")
    private TypeEnum type;

    public IssueTypeCreateBean name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique name for the issue type. The maximum length is 60 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IssueTypeCreateBean description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the issue type.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueTypeCreateBean type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Whether the issue type is `subtype` or `standard`. Defaults to `standard`.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeCreateBean issueTypeCreateBean = (IssueTypeCreateBean)o;
        return Objects.equals(this.name, issueTypeCreateBean.name) && Objects.equals(this.description, issueTypeCreateBean.description) && Objects.equals((Object)this.type, (Object)issueTypeCreateBean.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypeCreateBean {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SUBTASK("subtask"),
        STANDARD("standard");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

