/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueLinkType;
import org.everit.atlassian.restclient.jiracloud.v3.model.LinkedIssue;

@ApiModel(description="Details of a link between issues.")
public class IssueLink {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="type")
    private IssueLinkType type;
    @JsonProperty(value="inwardIssue")
    private LinkedIssue inwardIssue;
    @JsonProperty(value="outwardIssue")
    private LinkedIssue outwardIssue;

    @ApiModelProperty(value="The ID of the issue link.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL of the issue link.")
    public URI getSelf() {
        return this.self;
    }

    public IssueLink type(IssueLinkType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of link between the issues.")
    public IssueLinkType getType() {
        return this.type;
    }

    public void setType(IssueLinkType type) {
        this.type = type;
    }

    public IssueLink inwardIssue(LinkedIssue inwardIssue) {
        this.inwardIssue = inwardIssue;
        return this;
    }

    @ApiModelProperty(value="The issue the link joins to.")
    public LinkedIssue getInwardIssue() {
        return this.inwardIssue;
    }

    public void setInwardIssue(LinkedIssue inwardIssue) {
        this.inwardIssue = inwardIssue;
    }

    public IssueLink outwardIssue(LinkedIssue outwardIssue) {
        this.outwardIssue = outwardIssue;
        return this;
    }

    @ApiModelProperty(value="The issue the link originates from.")
    public LinkedIssue getOutwardIssue() {
        return this.outwardIssue;
    }

    public void setOutwardIssue(LinkedIssue outwardIssue) {
        this.outwardIssue = outwardIssue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLink issueLink = (IssueLink)o;
        return Objects.equals(this.id, issueLink.id) && Objects.equals(this.self, issueLink.self) && Objects.equals(this.type, issueLink.type) && Objects.equals(this.inwardIssue, issueLink.inwardIssue) && Objects.equals(this.outwardIssue, issueLink.outwardIssue);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.self, this.type, this.inwardIssue, this.outwardIssue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueLink {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    inwardIssue: ").append(this.toIndentedString(this.inwardIssue)).append("\n");
        sb.append("    outwardIssue: ").append(this.toIndentedString(this.outwardIssue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

