/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IncludedFields;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTransition;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueUpdateMetadata;
import org.everit.atlassian.restclient.jiracloud.v3.model.JsonTypeBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.Operations;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageOfChangelogs;

public class IssueBean {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="renderedFields")
    private Map<String, Object> renderedFields = new HashMap<String, Object>();
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="names")
    private Map<String, String> names = new HashMap<String, String>();
    @JsonProperty(value="schema")
    private Map<String, JsonTypeBean> schema = new HashMap<String, JsonTypeBean>();
    @JsonProperty(value="transitions")
    private List<IssueTransition> transitions = new ArrayList<IssueTransition>();
    @JsonProperty(value="operations")
    private Operations operations;
    @JsonProperty(value="editmeta")
    private IssueUpdateMetadata editmeta;
    @JsonProperty(value="changelog")
    private PageOfChangelogs changelog;
    @JsonProperty(value="versionedRepresentations")
    private Map<String, Map<String, Object>> versionedRepresentations = new HashMap<String, Map<String, Object>>();
    @JsonProperty(value="fieldsToInclude")
    private IncludedFields fieldsToInclude;
    @JsonProperty(value="fields")
    private Map<String, Object> fields = new HashMap<String, Object>();

    @ApiModelProperty(value="Expand options that include additional issue details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="The ID of the issue.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL of the issue details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The key of the issue.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="The rendered value of each field present on the issue.")
    public Map<String, Object> getRenderedFields() {
        return this.renderedFields;
    }

    @ApiModelProperty(value="Details of the issue properties identified in the request.")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="The ID and name of each field present on the issue.")
    public Map<String, String> getNames() {
        return this.names;
    }

    @ApiModelProperty(value="The schema describing each field present on the issue.")
    public Map<String, JsonTypeBean> getSchema() {
        return this.schema;
    }

    @ApiModelProperty(value="The transitions that can be performed on the issue.")
    public List<IssueTransition> getTransitions() {
        return this.transitions;
    }

    @ApiModelProperty(value="The operations that can be performed on the issue.")
    public Operations getOperations() {
        return this.operations;
    }

    @ApiModelProperty(value="The metadata for the fields on the issue that can be amended.")
    public IssueUpdateMetadata getEditmeta() {
        return this.editmeta;
    }

    @ApiModelProperty(value="Details of changelogs associated with the issue.")
    public PageOfChangelogs getChangelog() {
        return this.changelog;
    }

    @ApiModelProperty(value="The versions of each field on the issue.")
    public Map<String, Map<String, Object>> getVersionedRepresentations() {
        return this.versionedRepresentations;
    }

    public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
        return this;
    }

    @ApiModelProperty(value="")
    public IncludedFields getFieldsToInclude() {
        return this.fieldsToInclude;
    }

    public void setFieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
    }

    public IssueBean fields(Map<String, Object> fields) {
        this.fields = fields;
        return this;
    }

    public IssueBean putFieldsItem(String key, Object fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueBean issueBean = (IssueBean)o;
        return Objects.equals(this.expand, issueBean.expand) && Objects.equals(this.id, issueBean.id) && Objects.equals(this.self, issueBean.self) && Objects.equals(this.key, issueBean.key) && Objects.equals(this.renderedFields, issueBean.renderedFields) && Objects.equals(this.properties, issueBean.properties) && Objects.equals(this.names, issueBean.names) && Objects.equals(this.schema, issueBean.schema) && Objects.equals(this.transitions, issueBean.transitions) && Objects.equals(this.operations, issueBean.operations) && Objects.equals(this.editmeta, issueBean.editmeta) && Objects.equals(this.changelog, issueBean.changelog) && Objects.equals(this.versionedRepresentations, issueBean.versionedRepresentations) && Objects.equals(this.fieldsToInclude, issueBean.fieldsToInclude) && Objects.equals(this.fields, issueBean.fields);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.id, this.self, this.key, this.renderedFields, this.properties, this.names, this.schema, this.transitions, this.operations, this.editmeta, this.changelog, this.versionedRepresentations, this.fieldsToInclude, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueBean {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    renderedFields: ").append(this.toIndentedString(this.renderedFields)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    transitions: ").append(this.toIndentedString(this.transitions)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    editmeta: ").append(this.toIndentedString(this.editmeta)).append("\n");
        sb.append("    changelog: ").append(this.toIndentedString(this.changelog)).append("\n");
        sb.append("    versionedRepresentations: ").append(this.toIndentedString(this.versionedRepresentations)).append("\n");
        sb.append("    fieldsToInclude: ").append(this.toIndentedString(this.fieldsToInclude)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

