/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.Visibility;

@ApiModel(description="A comment.")
public class Comment {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="author")
    private UserDetails author;
    @JsonProperty(value="body")
    private Object body = null;
    @JsonProperty(value="renderedBody")
    private String renderedBody;
    @JsonProperty(value="updateAuthor")
    private UserDetails updateAuthor;
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="updated")
    private OffsetDateTime updated;
    @JsonProperty(value="visibility")
    private Visibility visibility;
    @JsonProperty(value="jsdPublic")
    private Boolean jsdPublic;
    @JsonProperty(value="properties")
    private List<EntityProperty> properties = new ArrayList<EntityProperty>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The URL of the comment.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The ID of the comment.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the user who created the comment.")
    public UserDetails getAuthor() {
        return this.author;
    }

    public Comment body(Object body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(value="The comment text in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/).")
    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    @ApiModelProperty(value="The rendered version of the comment.")
    public String getRenderedBody() {
        return this.renderedBody;
    }

    @ApiModelProperty(value="The ID of the user who updated the comment last.")
    public UserDetails getUpdateAuthor() {
        return this.updateAuthor;
    }

    @ApiModelProperty(value="The date and time at which the comment was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The date and time at which the comment was updated last.")
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public Comment visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(value="The group or role to which this comment is visible. Optional on create and update.")
    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @ApiModelProperty(value="Whether the comment is visible in Jira Service Desk. Defaults to true when comments are created in the Jira Cloud Platform. This includes when the site doesn't use Jira Service Desk or the project isn't a Jira Service Desk project and, therefore, there is no Jira Service Desk for the issue to be visible on. To create a comment with its visibility in Jira Service Desk set to false, use the Jira Service Desk REST API [Create request comment](https://developer.atlassian.com/cloud/jira/service-desk/rest/#api-rest-servicedeskapi-request-issueIdOrKey-comment-post) operation.")
    public Boolean getJsdPublic() {
        return this.jsdPublic;
    }

    public Comment properties(List<EntityProperty> properties) {
        this.properties = properties;
        return this;
    }

    public Comment addPropertiesItem(EntityProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<EntityProperty>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="A list of comment properties. Optional on create and update.")
    public List<EntityProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<EntityProperty> properties) {
        this.properties = properties;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment comment = (Comment)o;
        return Objects.equals(this.self, comment.self) && Objects.equals(this.id, comment.id) && Objects.equals(this.author, comment.author) && Objects.equals(this.body, comment.body) && Objects.equals(this.renderedBody, comment.renderedBody) && Objects.equals(this.updateAuthor, comment.updateAuthor) && Objects.equals(this.created, comment.created) && Objects.equals(this.updated, comment.updated) && Objects.equals(this.visibility, comment.visibility) && Objects.equals(this.jsdPublic, comment.jsdPublic) && Objects.equals(this.properties, comment.properties) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.author, this.body, this.renderedBody, this.updateAuthor, this.created, this.updated, this.visibility, this.jsdPublic, this.properties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Comment {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    renderedBody: ").append(this.toIndentedString(this.renderedBody)).append("\n");
        sb.append("    updateAuthor: ").append(this.toIndentedString(this.updateAuthor)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("    jsdPublic: ").append(this.toIndentedString(this.jsdPublic)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

