/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.ContainerForRegisteredWebhooks;
import org.everit.atlassian.restclient.jiracloud.v3.model.ContainerForWebhookIDs;
import org.everit.atlassian.restclient.jiracloud.v3.model.FailedWebhooks;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanWebhook;
import org.everit.atlassian.restclient.jiracloud.v3.model.WebhookRegistrationDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.WebhooksExpirationDate;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class WebhooksApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<PageBeanWebhook> returnType_getDynamicWebhooksForApp = new TypeReference<PageBeanWebhook>(){};
    private static final TypeReference<FailedWebhooks> returnType_getFailedWebhooks = new TypeReference<FailedWebhooks>(){};
    private static final TypeReference<WebhooksExpirationDate> returnType_refreshWebhooks = new TypeReference<WebhooksExpirationDate>(){};
    private static final TypeReference<ContainerForRegisteredWebhooks> returnType_registerDynamicWebhooks = new TypeReference<ContainerForRegisteredWebhooks>(){};
    private final RestClient restClient;

    public WebhooksApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable deleteWebhookById(ContainerForWebhookIDs containerForWebhookIDs, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/webhook");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(containerForWebhookIDs));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<PageBeanWebhook> getDynamicWebhooksForApp(Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/webhook");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDynamicWebhooksForApp);
    }

    public Single<FailedWebhooks> getFailedWebhooks(Optional<Integer> maxResults, Optional<Long> after, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/webhook/failed");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (after.isPresent()) {
            queryParams.put("after", Collections.singleton(String.valueOf(after.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFailedWebhooks);
    }

    public Single<WebhooksExpirationDate> refreshWebhooks(ContainerForWebhookIDs containerForWebhookIDs, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/webhook/refresh");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(containerForWebhookIDs));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_refreshWebhooks);
    }

    public Single<ContainerForRegisteredWebhooks> registerDynamicWebhooks(WebhookRegistrationDetails webhookRegistrationDetails, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/webhook");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(webhookRegistrationDetails));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_registerDynamicWebhooks);
    }
}

