/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeWithStatus;
import org.everit.atlassian.restclient.jiracloud.v3.model.NotificationScheme;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanProject;
import org.everit.atlassian.restclient.jiracloud.v3.model.Project;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectIdentifiers;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectInputBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectIssueTypeHierarchy;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Object> returnType_archiveProject = new TypeReference<Object>(){};
    private static final TypeReference<ProjectIdentifiers> returnType_createProject = new TypeReference<ProjectIdentifiers>(){};
    private static final TypeReference<List<Project>> returnType_getAllProjects = new TypeReference<List<Project>>(){};
    private static final TypeReference<List<IssueTypeWithStatus>> returnType_getAllStatuses = new TypeReference<List<IssueTypeWithStatus>>(){};
    private static final TypeReference<ProjectIssueTypeHierarchy> returnType_getHierarchy = new TypeReference<ProjectIssueTypeHierarchy>(){};
    private static final TypeReference<NotificationScheme> returnType_getNotificationSchemeForProject = new TypeReference<NotificationScheme>(){};
    private static final TypeReference<Project> returnType_getProject = new TypeReference<Project>(){};
    private static final TypeReference<Project> returnType_restore = new TypeReference<Project>(){};
    private static final TypeReference<PageBeanProject> returnType_searchProjects = new TypeReference<PageBeanProject>(){};
    private static final TypeReference<Project> returnType_updateProject = new TypeReference<Project>(){};
    private static final TypeReference<Project> returnType_updateProjectType = new TypeReference<Project>(){};
    private final RestClient restClient;

    public ProjectsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> archiveProject(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/archive");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_archiveProject);
    }

    public Single<ProjectIdentifiers> createProject(ProjectInputBean projectInputBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectInputBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createProject);
    }

    public Completable deleteProject(String projectIdOrKey, Optional<Boolean> enableUndo, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (enableUndo.isPresent()) {
            queryParams.put("enableUndo", Collections.singleton(String.valueOf(enableUndo.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteProjectAsynchronously(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/delete");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    @Deprecated
    public Single<List<Project>> getAllProjects(Optional<String> expand, Optional<Integer> recent, Optional<List<String>> properties, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (recent.isPresent()) {
            queryParams.put("recent", Collections.singleton(String.valueOf(recent.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllProjects);
    }

    public Single<List<IssueTypeWithStatus>> getAllStatuses(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/statuses");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllStatuses);
    }

    public Single<ProjectIssueTypeHierarchy> getHierarchy(Long projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectId}/hierarchy");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectId", String.valueOf(projectId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getHierarchy);
    }

    public Single<NotificationScheme> getNotificationSchemeForProject(String projectKeyOrId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectKeyOrId}/notificationscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getNotificationSchemeForProject);
    }

    public Single<Project> getProject(String projectIdOrKey, Optional<String> expand, Optional<List<String>> properties, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProject);
    }

    public Single<Project> restore(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/restore");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_restore);
    }

    public Single<PageBeanProject> searchProjects(Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> orderBy, Optional<String> query, Optional<String> typeKey, Optional<Long> categoryId, Optional<String> searchBy, Optional<String> action, Optional<String> expand, Optional<List<String>> status, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (typeKey.isPresent()) {
            queryParams.put("typeKey", Collections.singleton(String.valueOf(typeKey.get())));
        }
        if (categoryId.isPresent()) {
            queryParams.put("categoryId", Collections.singleton(String.valueOf(categoryId.get())));
        }
        if (searchBy.isPresent()) {
            queryParams.put("searchBy", Collections.singleton(String.valueOf(searchBy.get())));
        }
        if (action.isPresent()) {
            queryParams.put("action", Collections.singleton(String.valueOf(action.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (status.isPresent()) {
            queryParams.put("status", RestClientUtil.objectCollectionToStringCollection((Collection)status.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchProjects);
    }

    public Single<Project> updateProject(String projectIdOrKey, ProjectInputBean projectInputBean, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectInputBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProject);
    }

    @Deprecated
    public Single<Project> updateProjectType(String projectIdOrKey, String newProjectTypeKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectIdOrKey}/type/{newProjectTypeKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("newProjectTypeKey", String.valueOf(newProjectTypeKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProjectType);
    }
}

