/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.IdBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.PermissionScheme;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectPermissionSchemeApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<PermissionScheme> returnType_assignPermissionScheme = new TypeReference<PermissionScheme>(){};
    private static final TypeReference<PermissionScheme> returnType_getAssignedPermissionScheme = new TypeReference<PermissionScheme>(){};
    private final RestClient restClient;

    public ProjectPermissionSchemeApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<PermissionScheme> assignPermissionScheme(String projectKeyOrId, IdBean idBean, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectKeyOrId}/permissionscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(idBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignPermissionScheme);
    }

    public Single<PermissionScheme> getAssignedPermissionScheme(String projectKeyOrId, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/project/{projectKeyOrId}/permissionscheme");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectKeyOrId", String.valueOf(projectKeyOrId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAssignedPermissionScheme);
    }
}

