/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.AddGroupBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.Group;
import org.everit.atlassian.restclient.jiracloud.v3.model.PageBeanUserDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.UpdateUserToGroupBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class GroupApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<Group> returnType_addUserToGroup = new TypeReference<Group>(){};
    private static final TypeReference<Group> returnType_createGroup = new TypeReference<Group>(){};
    private static final TypeReference<Group> returnType_getGroup = new TypeReference<Group>(){};
    private static final TypeReference<PageBeanUserDetails> returnType_getUsersFromGroup = new TypeReference<PageBeanUserDetails>(){};
    private final RestClient restClient;

    public GroupApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Group> addUserToGroup(UpdateUserToGroupBean requestBody, Optional<String> groupname, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addUserToGroup);
    }

    public Single<Group> createGroup(AddGroupBean requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createGroup);
    }

    @Deprecated
    public Single<Group> getGroup(Optional<String> groupname, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getGroup);
    }

    public Single<PageBeanUserDetails> getUsersFromGroup(Optional<String> groupname, Optional<Boolean> includeInactiveUsers, Optional<Long> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group/member");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (includeInactiveUsers.isPresent()) {
            queryParams.put("includeInactiveUsers", Collections.singleton(String.valueOf(includeInactiveUsers.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUsersFromGroup);
    }

    public Completable removeGroup(Optional<String> groupname, Optional<String> swapGroup, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (swapGroup.isPresent()) {
            queryParams.put("swapGroup", Collections.singleton(String.valueOf(swapGroup.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable removeUserFromGroup(Optional<String> groupname, Optional<String> username, Optional<String> accountId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/group/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (groupname.isPresent()) {
            queryParams.put("groupname", Collections.singleton(String.valueOf(groupname.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }
}

