/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of Jira expressions for analysis.")
public class JiraExpressionForAnalysis {
    @JsonProperty(value="expressions")
    private List<String> expressions = new ArrayList<String>();
    @JsonProperty(value="contextVariables")
    private Map<String, String> contextVariables = new HashMap<String, String>();

    public JiraExpressionForAnalysis expressions(List<String> expressions) {
        this.expressions = expressions;
        return this;
    }

    public JiraExpressionForAnalysis addExpressionsItem(String expressionsItem) {
        this.expressions.add(expressionsItem);
        return this;
    }

    @ApiModelProperty(example="issues.map(issue => issue.properties['property_key'])", required=true, value="The list of Jira expressions to analyse.")
    public List<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<String> expressions) {
        this.expressions = expressions;
    }

    public JiraExpressionForAnalysis contextVariables(Map<String, String> contextVariables) {
        this.contextVariables = contextVariables;
        return this;
    }

    public JiraExpressionForAnalysis putContextVariablesItem(String key, String contextVariablesItem) {
        if (this.contextVariables == null) {
            this.contextVariables = new HashMap<String, String>();
        }
        this.contextVariables.put(key, contextVariablesItem);
        return this;
    }

    @ApiModelProperty(value="Context variables and their types. The type checker assumes that [common context variables](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#context-variables), such as `issue` or `project`, are available in context and sets their type. Use this property to override the default types or provide details of new variables.")
    public Map<String, String> getContextVariables() {
        return this.contextVariables;
    }

    public void setContextVariables(Map<String, String> contextVariables) {
        this.contextVariables = contextVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraExpressionForAnalysis jiraExpressionForAnalysis = (JiraExpressionForAnalysis)o;
        return Objects.equals(this.expressions, jiraExpressionForAnalysis.expressions) && Objects.equals(this.contextVariables, jiraExpressionForAnalysis.contextVariables);
    }

    public int hashCode() {
        return Objects.hash(this.expressions, this.contextVariables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraExpressionForAnalysis {\n");
        sb.append("    expressions: ").append(this.toIndentedString(this.expressions)).append("\n");
        sb.append("    contextVariables: ").append(this.toIndentedString(this.contextVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

