/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.JqlQueryClauseTimePredicate;
import org.everit.atlassian.restclient.jiracloud.v2.model.JqlQueryField;

@ApiModel(description="A clause that asserts whether a field was changed. For example, `status CHANGED AFTER startOfMonth(-1M)`.See [CHANGED](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for more information about the CHANGED operator.")
public class FieldChangedClause {
    @JsonProperty(value="field")
    private JqlQueryField field;
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonProperty(value="predicates")
    private List<JqlQueryClauseTimePredicate> predicates = new ArrayList<JqlQueryClauseTimePredicate>();

    public FieldChangedClause field(JqlQueryField field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryField getField() {
        return this.field;
    }

    public void setField(JqlQueryField field) {
        this.field = field;
    }

    public FieldChangedClause operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The operator applied to the field.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public FieldChangedClause predicates(List<JqlQueryClauseTimePredicate> predicates) {
        this.predicates = predicates;
        return this;
    }

    public FieldChangedClause addPredicatesItem(JqlQueryClauseTimePredicate predicatesItem) {
        this.predicates.add(predicatesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of time predicates.")
    public List<JqlQueryClauseTimePredicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<JqlQueryClauseTimePredicate> predicates) {
        this.predicates = predicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldChangedClause fieldChangedClause = (FieldChangedClause)o;
        return Objects.equals(this.field, fieldChangedClause.field) && Objects.equals((Object)this.operator, (Object)fieldChangedClause.operator) && Objects.equals(this.predicates, fieldChangedClause.predicates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.operator, this.predicates});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldChangedClause {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    predicates: ").append(this.toIndentedString(this.predicates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        CHANGED("changed");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

