/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectEmailAddress;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectEmailApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<ProjectEmailAddress> returnType_getProjectEmail = new TypeReference<ProjectEmailAddress>(){};
    private static final TypeReference<Object> returnType_updateProjectEmail = new TypeReference<Object>(){};
    private final RestClient restClient;

    public ProjectEmailApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ProjectEmailAddress> getProjectEmail(Long projectId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectId}/email");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectId", String.valueOf(projectId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectEmail);
    }

    public Single<Object> updateProjectEmail(Long projectId, ProjectEmailAddress projectEmailAddress, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectId}/email");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectId", String.valueOf(projectId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectEmailAddress));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProjectEmail);
    }
}

