/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.Avatar;
import org.everit.atlassian.restclient.jiracloud.v2.model.Component;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeWithStatus;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanComponentWithIssueCount;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanProject;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanVersion;
import org.everit.atlassian.restclient.jiracloud.v2.model.Project;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectAvatars;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectIdentifiers;
import org.everit.atlassian.restclient.jiracloud.v2.model.ProjectInputBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Version;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<ProjectIdentifiers> returnType_createProject = new TypeReference<ProjectIdentifiers>(){};
    private static final TypeReference<Avatar> returnType_createProjectAvatar = new TypeReference<Avatar>(){};
    private static final TypeReference<ProjectAvatars> returnType_getAllProjectAvatars = new TypeReference<ProjectAvatars>(){};
    private static final TypeReference<List<Project>> returnType_getAllProjects = new TypeReference<List<Project>>(){};
    private static final TypeReference<List<IssueTypeWithStatus>> returnType_getAllStatuses = new TypeReference<List<IssueTypeWithStatus>>(){};
    private static final TypeReference<Project> returnType_getProject = new TypeReference<Project>(){};
    private static final TypeReference<List<Component>> returnType_getProjectComponents = new TypeReference<List<Component>>(){};
    private static final TypeReference<PageBeanComponentWithIssueCount> returnType_getProjectComponentsPaginated = new TypeReference<PageBeanComponentWithIssueCount>(){};
    private static final TypeReference<List<Version>> returnType_getProjectVersions = new TypeReference<List<Version>>(){};
    private static final TypeReference<PageBeanVersion> returnType_getProjectVersionsPaginated = new TypeReference<PageBeanVersion>(){};
    private static final TypeReference<PageBeanProject> returnType_searchProjects = new TypeReference<PageBeanProject>(){};
    private static final TypeReference<Project> returnType_updateProject = new TypeReference<Project>(){};
    private static final TypeReference<Object> returnType_updateProjectAvatar = new TypeReference<Object>(){};
    private static final TypeReference<Project> returnType_updateProjectType = new TypeReference<Project>(){};
    private final RestClient restClient;

    public ProjectApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ProjectIdentifiers> createProject(ProjectInputBean projectInputBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectInputBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createProject);
    }

    public Single<Avatar> createProjectAvatar(String projectIdOrKey, Object body, Optional<Integer> x, Optional<Integer> y, Optional<Integer> size, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/avatar2");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (x.isPresent()) {
            queryParams.put("x", Collections.singleton(String.valueOf(x.get())));
        }
        if (y.isPresent()) {
            queryParams.put("y", Collections.singleton(String.valueOf(y.get())));
        }
        if (size.isPresent()) {
            queryParams.put("size", Collections.singleton(String.valueOf(size.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createProjectAvatar);
    }

    public Completable deleteProject(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteProjectAvatar(String projectIdOrKey, Long id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/avatar/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<ProjectAvatars> getAllProjectAvatars(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/avatars");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllProjectAvatars);
    }

    @Deprecated
    public Single<List<Project>> getAllProjects(Optional<String> expand, Optional<Integer> recent, Optional<List<String>> properties, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (recent.isPresent()) {
            queryParams.put("recent", Collections.singleton(String.valueOf(recent.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllProjects);
    }

    public Single<List<IssueTypeWithStatus>> getAllStatuses(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/statuses");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllStatuses);
    }

    public Single<Project> getProject(String projectIdOrKey, Optional<String> expand, Optional<List<String>> properties, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProject);
    }

    public Single<List<Component>> getProjectComponents(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/components");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectComponents);
    }

    public Single<PageBeanComponentWithIssueCount> getProjectComponentsPaginated(String projectIdOrKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> orderBy, Optional<String> query, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/component");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectComponentsPaginated);
    }

    public Single<List<Version>> getProjectVersions(String projectIdOrKey, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/versions");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectVersions);
    }

    public Single<PageBeanVersion> getProjectVersionsPaginated(String projectIdOrKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> orderBy, Optional<String> query, Optional<String> status, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/version");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (status.isPresent()) {
            queryParams.put("status", Collections.singleton(String.valueOf(status.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectVersionsPaginated);
    }

    public Single<PageBeanProject> searchProjects(Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> orderBy, Optional<String> query, Optional<String> typeKey, Optional<Long> categoryId, Optional<String> searchBy, Optional<String> action, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (typeKey.isPresent()) {
            queryParams.put("typeKey", Collections.singleton(String.valueOf(typeKey.get())));
        }
        if (categoryId.isPresent()) {
            queryParams.put("categoryId", Collections.singleton(String.valueOf(categoryId.get())));
        }
        if (searchBy.isPresent()) {
            queryParams.put("searchBy", Collections.singleton(String.valueOf(searchBy.get())));
        }
        if (action.isPresent()) {
            queryParams.put("action", Collections.singleton(String.valueOf(action.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_searchProjects);
    }

    public Single<Project> updateProject(String projectIdOrKey, ProjectInputBean projectInputBean, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(projectInputBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProject);
    }

    public Single<Object> updateProjectAvatar(String projectIdOrKey, Avatar avatar, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/avatar");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(avatar));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProjectAvatar);
    }

    @Deprecated
    public Single<Project> updateProjectType(String projectIdOrKey, String newProjectTypeKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/type/{newProjectTypeKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        pathParams.put("newProjectTypeKey", String.valueOf(newProjectTypeKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateProjectType);
    }
}

