/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.AutoCompleteSuggestions;
import org.everit.atlassian.restclient.jiracloud.v2.model.ConvertedJQLQueries;
import org.everit.atlassian.restclient.jiracloud.v2.model.JQLPersonalDataMigrationRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.JQLReferenceData;
import org.everit.atlassian.restclient.jiracloud.v2.model.JqlQueriesToParse;
import org.everit.atlassian.restclient.jiracloud.v2.model.ParsedJqlQueries;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class JqlApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<JQLReferenceData> returnType_getAutoComplete = new TypeReference<JQLReferenceData>(){};
    private static final TypeReference<AutoCompleteSuggestions> returnType_getFieldAutoCompleteForQueryString = new TypeReference<AutoCompleteSuggestions>(){};
    private static final TypeReference<ConvertedJQLQueries> returnType_migrateQueries = new TypeReference<ConvertedJQLQueries>(){};
    private static final TypeReference<ParsedJqlQueries> returnType_parseJqlQueries = new TypeReference<ParsedJqlQueries>(){};
    private final RestClient restClient;

    public JqlApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<JQLReferenceData> getAutoComplete(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/jql/autocompletedata");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAutoComplete);
    }

    public Single<AutoCompleteSuggestions> getFieldAutoCompleteForQueryString(Optional<String> fieldName, Optional<String> fieldValue, Optional<String> predicateName, Optional<String> predicateValue, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/jql/autocompletedata/suggestions");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (fieldName.isPresent()) {
            queryParams.put("fieldName", Collections.singleton(String.valueOf(fieldName.get())));
        }
        if (fieldValue.isPresent()) {
            queryParams.put("fieldValue", Collections.singleton(String.valueOf(fieldValue.get())));
        }
        if (predicateName.isPresent()) {
            queryParams.put("predicateName", Collections.singleton(String.valueOf(predicateName.get())));
        }
        if (predicateValue.isPresent()) {
            queryParams.put("predicateValue", Collections.singleton(String.valueOf(predicateValue.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getFieldAutoCompleteForQueryString);
    }

    public Single<ConvertedJQLQueries> migrateQueries(JQLPersonalDataMigrationRequest jqLPersonalDataMigrationRequest, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/jql/pdcleaner");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(jqLPersonalDataMigrationRequest));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_migrateQueries);
    }

    public Single<ParsedJqlQueries> parseJqlQueries(JqlQueriesToParse jqlQueriesToParse, Optional<String> validation, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/jql/parse");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (validation.isPresent()) {
            queryParams.put("validation", Collections.singleton(String.valueOf(validation.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(jqlQueriesToParse));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_parseJqlQueries);
    }
}

