/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.ChangedWorklogs;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageOfWorklogs;
import org.everit.atlassian.restclient.jiracloud.v2.model.Worklog;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorklogIdsRequestBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueWorklogsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Worklog> returnType_addWorklog = new TypeReference<Worklog>(){};
    private static final TypeReference<ChangedWorklogs> returnType_getIdsOfWorklogsDeletedSince = new TypeReference<ChangedWorklogs>(){};
    private static final TypeReference<ChangedWorklogs> returnType_getIdsOfWorklogsModifiedSince = new TypeReference<ChangedWorklogs>(){};
    private static final TypeReference<PageOfWorklogs> returnType_getIssueWorklog = new TypeReference<PageOfWorklogs>(){};
    private static final TypeReference<Worklog> returnType_getWorklog = new TypeReference<Worklog>(){};
    private static final TypeReference<List<Worklog>> returnType_getWorklogsForIds = new TypeReference<List<Worklog>>(){};
    private static final TypeReference<Worklog> returnType_updateWorklog = new TypeReference<Worklog>(){};
    private final RestClient restClient;

    public IssueWorklogsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Worklog> addWorklog(String issueIdOrKey, Worklog requestBody, Optional<Boolean> notifyUsers, Optional<String> adjustEstimate, Optional<String> newEstimate, Optional<String> reduceBy, Optional<String> expand, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/worklog");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (notifyUsers.isPresent()) {
            queryParams.put("notifyUsers", Collections.singleton(String.valueOf(notifyUsers.get())));
        }
        if (adjustEstimate.isPresent()) {
            queryParams.put("adjustEstimate", Collections.singleton(String.valueOf(adjustEstimate.get())));
        }
        if (newEstimate.isPresent()) {
            queryParams.put("newEstimate", Collections.singleton(String.valueOf(newEstimate.get())));
        }
        if (reduceBy.isPresent()) {
            queryParams.put("reduceBy", Collections.singleton(String.valueOf(reduceBy.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addWorklog);
    }

    public Completable deleteWorklog(String issueIdOrKey, String id, Optional<Boolean> notifyUsers, Optional<String> adjustEstimate, Optional<String> newEstimate, Optional<String> increaseBy, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/worklog/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (notifyUsers.isPresent()) {
            queryParams.put("notifyUsers", Collections.singleton(String.valueOf(notifyUsers.get())));
        }
        if (adjustEstimate.isPresent()) {
            queryParams.put("adjustEstimate", Collections.singleton(String.valueOf(adjustEstimate.get())));
        }
        if (newEstimate.isPresent()) {
            queryParams.put("newEstimate", Collections.singleton(String.valueOf(newEstimate.get())));
        }
        if (increaseBy.isPresent()) {
            queryParams.put("increaseBy", Collections.singleton(String.valueOf(increaseBy.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<ChangedWorklogs> getIdsOfWorklogsDeletedSince(Optional<Long> since, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/worklog/deleted");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (since.isPresent()) {
            queryParams.put("since", Collections.singleton(String.valueOf(since.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIdsOfWorklogsDeletedSince);
    }

    public Single<ChangedWorklogs> getIdsOfWorklogsModifiedSince(Optional<Long> since, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/worklog/updated");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (since.isPresent()) {
            queryParams.put("since", Collections.singleton(String.valueOf(since.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIdsOfWorklogsModifiedSince);
    }

    public Single<PageOfWorklogs> getIssueWorklog(String issueIdOrKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<Long> startedAfter, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/worklog");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (startedAfter.isPresent()) {
            queryParams.put("startedAfter", Collections.singleton(String.valueOf(startedAfter.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueWorklog);
    }

    public Single<Worklog> getWorklog(String issueIdOrKey, String id, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/worklog/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorklog);
    }

    public Single<List<Worklog>> getWorklogsForIds(WorklogIdsRequestBean worklogIdsRequestBean, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/worklog/list");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(worklogIdsRequestBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorklogsForIds);
    }

    public Single<Worklog> updateWorklog(String issueIdOrKey, String id, Worklog requestBody, Optional<Boolean> notifyUsers, Optional<String> adjustEstimate, Optional<String> newEstimate, Optional<String> expand, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/worklog/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (notifyUsers.isPresent()) {
            queryParams.put("notifyUsers", Collections.singleton(String.valueOf(notifyUsers.get())));
        }
        if (adjustEstimate.isPresent()) {
            queryParams.put("adjustEstimate", Collections.singleton(String.valueOf(adjustEstimate.get())));
        }
        if (newEstimate.isPresent()) {
            queryParams.put("newEstimate", Collections.singleton(String.valueOf(newEstimate.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorklog);
    }
}

