/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v2.model.Attachment;
import org.everit.atlassian.restclient.jiracloud.v2.model.AttachmentArchiveImpl;
import org.everit.atlassian.restclient.jiracloud.v2.model.AttachmentArchiveMetadataReadable;
import org.everit.atlassian.restclient.jiracloud.v2.model.AttachmentMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.AttachmentSettings;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueAttachmentsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<List<Attachment>> returnType_addAttachment = new TypeReference<List<Attachment>>(){};
    private static final TypeReference<AttachmentArchiveMetadataReadable> returnType_expandAttachmentForHumans = new TypeReference<AttachmentArchiveMetadataReadable>(){};
    private static final TypeReference<AttachmentArchiveImpl> returnType_expandAttachmentForMachines = new TypeReference<AttachmentArchiveImpl>(){};
    private static final TypeReference<AttachmentMetadata> returnType_getAttachment = new TypeReference<AttachmentMetadata>(){};
    private static final TypeReference<AttachmentSettings> returnType_getAttachmentMeta = new TypeReference<AttachmentSettings>(){};
    private final RestClient restClient;

    public IssueAttachmentsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<List<Attachment>> addAttachment(String issueIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/attachments");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addAttachment);
    }

    public Single<AttachmentArchiveMetadataReadable> expandAttachmentForHumans(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/attachment/{id}/expand/human");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_expandAttachmentForHumans);
    }

    public Single<AttachmentArchiveImpl> expandAttachmentForMachines(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/attachment/{id}/expand/raw");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_expandAttachmentForMachines);
    }

    public Single<AttachmentMetadata> getAttachment(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/attachment/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAttachment);
    }

    public Single<AttachmentSettings> getAttachmentMeta(Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/attachment/meta");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAttachmentMeta);
    }

    public Completable removeAttachment(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/attachment/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }
}

