/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.TimeTrackingConfiguration;

/**
 * Details about the configuration of Jira.
 */
@ApiModel(description = "Details about the configuration of Jira.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-10-28T14:12:40.546+01:00[Europe/Prague]")
public class ModelConfiguration {
  @JsonProperty("votingEnabled")
  private Boolean votingEnabled;

  @JsonProperty("watchingEnabled")
  private Boolean watchingEnabled;

  @JsonProperty("unassignedIssuesAllowed")
  private Boolean unassignedIssuesAllowed;

  @JsonProperty("subTasksEnabled")
  private Boolean subTasksEnabled;

  @JsonProperty("issueLinkingEnabled")
  private Boolean issueLinkingEnabled;

  @JsonProperty("timeTrackingEnabled")
  private Boolean timeTrackingEnabled;

  @JsonProperty("attachmentsEnabled")
  private Boolean attachmentsEnabled;

  @JsonProperty("timeTrackingConfiguration")
  private TimeTrackingConfiguration timeTrackingConfiguration;

   /**
   * Whether the ability for users to vote on issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   * @return votingEnabled
  **/
  @ApiModelProperty(value = "Whether the ability for users to vote on issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.")
  public Boolean getVotingEnabled() {
    return votingEnabled;
  }

   /**
   * Whether the ability for users to watch issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   * @return watchingEnabled
  **/
  @ApiModelProperty(value = "Whether the ability for users to watch issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.")
  public Boolean getWatchingEnabled() {
    return watchingEnabled;
  }

   /**
   * Whether the ability to create unassigned issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   * @return unassignedIssuesAllowed
  **/
  @ApiModelProperty(value = "Whether the ability to create unassigned issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.")
  public Boolean getUnassignedIssuesAllowed() {
    return unassignedIssuesAllowed;
  }

   /**
   * Whether the ability to create subtasks for issues is enabled.
   * @return subTasksEnabled
  **/
  @ApiModelProperty(value = "Whether the ability to create subtasks for issues is enabled.")
  public Boolean getSubTasksEnabled() {
    return subTasksEnabled;
  }

   /**
   * Whether the ability to link issues is enabled.
   * @return issueLinkingEnabled
  **/
  @ApiModelProperty(value = "Whether the ability to link issues is enabled.")
  public Boolean getIssueLinkingEnabled() {
    return issueLinkingEnabled;
  }

   /**
   * Whether the ability to track time is enabled. This property is deprecated.
   * @return timeTrackingEnabled
  **/
  @ApiModelProperty(value = "Whether the ability to track time is enabled. This property is deprecated.")
  public Boolean getTimeTrackingEnabled() {
    return timeTrackingEnabled;
  }

   /**
   * Whether the ability to add attachments to issues is enabled.
   * @return attachmentsEnabled
  **/
  @ApiModelProperty(value = "Whether the ability to add attachments to issues is enabled.")
  public Boolean getAttachmentsEnabled() {
    return attachmentsEnabled;
  }

   /**
   * The configuration of time tracking.
   * @return timeTrackingConfiguration
  **/
  @ApiModelProperty(value = "The configuration of time tracking.")
  public TimeTrackingConfiguration getTimeTrackingConfiguration() {
    return timeTrackingConfiguration;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModelConfiguration _configuration = (ModelConfiguration) o;
    return Objects.equals(this.votingEnabled, _configuration.votingEnabled) &&
        Objects.equals(this.watchingEnabled, _configuration.watchingEnabled) &&
        Objects.equals(this.unassignedIssuesAllowed, _configuration.unassignedIssuesAllowed) &&
        Objects.equals(this.subTasksEnabled, _configuration.subTasksEnabled) &&
        Objects.equals(this.issueLinkingEnabled, _configuration.issueLinkingEnabled) &&
        Objects.equals(this.timeTrackingEnabled, _configuration.timeTrackingEnabled) &&
        Objects.equals(this.attachmentsEnabled, _configuration.attachmentsEnabled) &&
        Objects.equals(this.timeTrackingConfiguration, _configuration.timeTrackingConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(votingEnabled, watchingEnabled, unassignedIssuesAllowed, subTasksEnabled, issueLinkingEnabled, timeTrackingEnabled, attachmentsEnabled, timeTrackingConfiguration);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModelConfiguration {\n");
    
    sb.append("    votingEnabled: ").append(toIndentedString(votingEnabled)).append("\n");
    sb.append("    watchingEnabled: ").append(toIndentedString(watchingEnabled)).append("\n");
    sb.append("    unassignedIssuesAllowed: ").append(toIndentedString(unassignedIssuesAllowed)).append("\n");
    sb.append("    subTasksEnabled: ").append(toIndentedString(subTasksEnabled)).append("\n");
    sb.append("    issueLinkingEnabled: ").append(toIndentedString(issueLinkingEnabled)).append("\n");
    sb.append("    timeTrackingEnabled: ").append(toIndentedString(timeTrackingEnabled)).append("\n");
    sb.append("    attachmentsEnabled: ").append(toIndentedString(attachmentsEnabled)).append("\n");
    sb.append("    timeTrackingConfiguration: ").append(toIndentedString(timeTrackingConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

