/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.AvatarUrlsBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.SimpleListWrapperApplicationRole;
import org.everit.atlassian.restclient.jiracloud.v3.model.SimpleListWrapperGroupName;

@ApiModel(description="A user with details as permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:   *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).  *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.  *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.")
public class User {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="accountId")
    private String accountId;
    @JsonProperty(value="accountType")
    private AccountTypeEnum accountType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="emailAddress")
    private String emailAddress;
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="active")
    private Boolean active;
    @JsonProperty(value="timeZone")
    private String timeZone;
    @JsonProperty(value="locale")
    private String locale;
    @JsonProperty(value="groups")
    private SimpleListWrapperGroupName groups;
    @JsonProperty(value="applicationRoles")
    private SimpleListWrapperApplicationRole applicationRoles;
    @JsonProperty(value="expand")
    private String expand;

    @ApiModelProperty(value="The URL of the user.")
    public URI getSelf() {
        return this.self;
    }

    public User key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public User accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required in requests.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The user account type. Can take the following values:   *  `atlassian` regular Atlassian user account  *  `app` system account used for Connect applications and OAuth to represent external systems  *  `customer` Jira Service Desk account representing an external service desk")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The email address of the user. Depending on the user\u2019s privacy setting, this may be returned as null.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @ApiModelProperty(value="The avatars of the user.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    @ApiModelProperty(value="The display name of the user. Depending on the user\u2019s privacy setting, this may return an alternative value.")
    public String getDisplayName() {
        return this.displayName;
    }

    @ApiModelProperty(value="Whether the user is active.")
    public Boolean getActive() {
        return this.active;
    }

    @ApiModelProperty(value="The time zone specified in the user's profile. Depending on the user\u2019s privacy setting, this may be returned as null.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="The locale of the user. Depending on the user\u2019s privacy setting, this may be returned as null.")
    public String getLocale() {
        return this.locale;
    }

    @ApiModelProperty(value="The groups that the user belongs to.")
    public SimpleListWrapperGroupName getGroups() {
        return this.groups;
    }

    @ApiModelProperty(value="The application roles the user is assigned to.")
    public SimpleListWrapperApplicationRole getApplicationRoles() {
        return this.applicationRoles;
    }

    @ApiModelProperty(value="Expand options that include additional user details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.self, user.self) && Objects.equals(this.key, user.key) && Objects.equals(this.accountId, user.accountId) && Objects.equals((Object)this.accountType, (Object)user.accountType) && Objects.equals(this.name, user.name) && Objects.equals(this.emailAddress, user.emailAddress) && Objects.equals(this.avatarUrls, user.avatarUrls) && Objects.equals(this.displayName, user.displayName) && Objects.equals(this.active, user.active) && Objects.equals(this.timeZone, user.timeZone) && Objects.equals(this.locale, user.locale) && Objects.equals(this.groups, user.groups) && Objects.equals(this.applicationRoles, user.applicationRoles) && Objects.equals(this.expand, user.expand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.self, this.key, this.accountId, this.accountType, this.name, this.emailAddress, this.avatarUrls, this.displayName, this.active, this.timeZone, this.locale, this.groups, this.applicationRoles, this.expand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    applicationRoles: ").append(this.toIndentedString(this.applicationRoles)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccountTypeEnum {
        ATLASSIAN("atlassian"),
        APP("app"),
        CUSTOMER("customer"),
        UNKNOWN("unknown");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

