/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.HealthCheckResult;

@ApiModel(description="Details about the Jira instance.")
public class ServerInformation {
    @JsonProperty(value="baseUrl")
    private String baseUrl;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="versionNumbers")
    private List<Integer> versionNumbers = new ArrayList<Integer>();
    @JsonProperty(value="deploymentType")
    private String deploymentType;
    @JsonProperty(value="buildNumber")
    private Integer buildNumber;
    @JsonProperty(value="buildDate")
    private OffsetDateTime buildDate;
    @JsonProperty(value="serverTime")
    private OffsetDateTime serverTime;
    @JsonProperty(value="scmInfo")
    private String scmInfo;
    @JsonProperty(value="serverTitle")
    private String serverTitle;
    @JsonProperty(value="healthChecks")
    private List<HealthCheckResult> healthChecks = new ArrayList<HealthCheckResult>();

    public ServerInformation baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @ApiModelProperty(value="The base URL of the Jira instance.")
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ServerInformation version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="The version of Jira.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServerInformation versionNumbers(List<Integer> versionNumbers) {
        this.versionNumbers = versionNumbers;
        return this;
    }

    public ServerInformation addVersionNumbersItem(Integer versionNumbersItem) {
        if (this.versionNumbers == null) {
            this.versionNumbers = new ArrayList<Integer>();
        }
        this.versionNumbers.add(versionNumbersItem);
        return this;
    }

    @ApiModelProperty(value="The major, minor, and revision version numbers of the Jira version.")
    public List<Integer> getVersionNumbers() {
        return this.versionNumbers;
    }

    public void setVersionNumbers(List<Integer> versionNumbers) {
        this.versionNumbers = versionNumbers;
    }

    public ServerInformation deploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    @ApiModelProperty(value="The type of server deployment. This is always returned as *Cloud*.")
    public String getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public ServerInformation buildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @ApiModelProperty(value="The build number of the Jira version.")
    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public ServerInformation buildDate(OffsetDateTime buildDate) {
        this.buildDate = buildDate;
        return this;
    }

    @ApiModelProperty(value="The timestamp when the Jira version was built.")
    public OffsetDateTime getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(OffsetDateTime buildDate) {
        this.buildDate = buildDate;
    }

    public ServerInformation serverTime(OffsetDateTime serverTime) {
        this.serverTime = serverTime;
        return this;
    }

    @ApiModelProperty(value="The time in Jira when this request was responded to.")
    public OffsetDateTime getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(OffsetDateTime serverTime) {
        this.serverTime = serverTime;
    }

    public ServerInformation scmInfo(String scmInfo) {
        this.scmInfo = scmInfo;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Jira version.")
    public String getScmInfo() {
        return this.scmInfo;
    }

    public void setScmInfo(String scmInfo) {
        this.scmInfo = scmInfo;
    }

    public ServerInformation serverTitle(String serverTitle) {
        this.serverTitle = serverTitle;
        return this;
    }

    @ApiModelProperty(value="The name of the Jira instance.")
    public String getServerTitle() {
        return this.serverTitle;
    }

    public void setServerTitle(String serverTitle) {
        this.serverTitle = serverTitle;
    }

    public ServerInformation healthChecks(List<HealthCheckResult> healthChecks) {
        this.healthChecks = healthChecks;
        return this;
    }

    public ServerInformation addHealthChecksItem(HealthCheckResult healthChecksItem) {
        if (this.healthChecks == null) {
            this.healthChecks = new ArrayList<HealthCheckResult>();
        }
        this.healthChecks.add(healthChecksItem);
        return this;
    }

    @ApiModelProperty(value="Jira instance health check results. Deprecated and no longer returned.")
    public List<HealthCheckResult> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<HealthCheckResult> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInformation serverInformation = (ServerInformation)o;
        return Objects.equals(this.baseUrl, serverInformation.baseUrl) && Objects.equals(this.version, serverInformation.version) && Objects.equals(this.versionNumbers, serverInformation.versionNumbers) && Objects.equals(this.deploymentType, serverInformation.deploymentType) && Objects.equals(this.buildNumber, serverInformation.buildNumber) && Objects.equals(this.buildDate, serverInformation.buildDate) && Objects.equals(this.serverTime, serverInformation.serverTime) && Objects.equals(this.scmInfo, serverInformation.scmInfo) && Objects.equals(this.serverTitle, serverInformation.serverTitle) && Objects.equals(this.healthChecks, serverInformation.healthChecks);
    }

    public int hashCode() {
        return Objects.hash(this.baseUrl, this.version, this.versionNumbers, this.deploymentType, this.buildNumber, this.buildDate, this.serverTime, this.scmInfo, this.serverTitle, this.healthChecks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerInformation {\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionNumbers: ").append(this.toIndentedString(this.versionNumbers)).append("\n");
        sb.append("    deploymentType: ").append(this.toIndentedString(this.deploymentType)).append("\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    buildDate: ").append(this.toIndentedString(this.buildDate)).append("\n");
        sb.append("    serverTime: ").append(this.toIndentedString(this.serverTime)).append("\n");
        sb.append("    scmInfo: ").append(this.toIndentedString(this.scmInfo)).append("\n");
        sb.append("    serverTitle: ").append(this.toIndentedString(this.serverTitle)).append("\n");
        sb.append("    healthChecks: ").append(this.toIndentedString(this.healthChecks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

