/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryClauseOperand;

@ApiModel(description="A time predicate for a temporal JQL clause.")
public class JqlQueryClauseTimePredicate {
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonProperty(value="operand")
    private JqlQueryClauseOperand operand;

    public JqlQueryClauseTimePredicate operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The operator between the field and the operand.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public JqlQueryClauseTimePredicate operand(JqlQueryClauseOperand operand) {
        this.operand = operand;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryClauseOperand getOperand() {
        return this.operand;
    }

    public void setOperand(JqlQueryClauseOperand operand) {
        this.operand = operand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlQueryClauseTimePredicate jqlQueryClauseTimePredicate = (JqlQueryClauseTimePredicate)o;
        return Objects.equals((Object)this.operator, (Object)jqlQueryClauseTimePredicate.operator) && Objects.equals(this.operand, jqlQueryClauseTimePredicate.operand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.operand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JqlQueryClauseTimePredicate {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    operand: ").append(this.toIndentedString(this.operand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        BEFORE("before"),
        AFTER("after"),
        FROM("from"),
        TO("to"),
        ON("on"),
        DURING("during"),
        BY("by");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

