/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.WorkflowTransitionProperty;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class WorkflowTransitionPropertiesApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<WorkflowTransitionProperty> returnType_createWorkflowTransitionProperty = new TypeReference<WorkflowTransitionProperty>(){};
    private static final TypeReference<WorkflowTransitionProperty> returnType_getWorkflowTransitionProperties = new TypeReference<WorkflowTransitionProperty>(){};
    private static final TypeReference<WorkflowTransitionProperty> returnType_updateWorkflowTransitionProperty = new TypeReference<WorkflowTransitionProperty>(){};
    private final RestClient restClient;

    public WorkflowTransitionPropertiesApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<WorkflowTransitionProperty> createWorkflowTransitionProperty(Long transitionId, String key, String workflowName, WorkflowTransitionProperty requestBody, Optional<String> workflowMode, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/transitions/{transitionId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("transitionId", String.valueOf(transitionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        queryParams.put("key", Collections.singleton(String.valueOf(key)));
        queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName)));
        if (workflowMode.isPresent()) {
            queryParams.put("workflowMode", Collections.singleton(String.valueOf(workflowMode.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createWorkflowTransitionProperty);
    }

    public Completable deleteWorkflowTransitionProperty(Long transitionId, String key, String workflowName, Optional<String> workflowMode, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/transitions/{transitionId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("transitionId", String.valueOf(transitionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        queryParams.put("key", Collections.singleton(String.valueOf(key)));
        queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName)));
        if (workflowMode.isPresent()) {
            queryParams.put("workflowMode", Collections.singleton(String.valueOf(workflowMode.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<WorkflowTransitionProperty> getWorkflowTransitionProperties(Long transitionId, String workflowName, Optional<Boolean> includeReservedKeys, Optional<String> key, Optional<String> workflowMode, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/transitions/{transitionId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("transitionId", String.valueOf(transitionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (includeReservedKeys.isPresent()) {
            queryParams.put("includeReservedKeys", Collections.singleton(String.valueOf(includeReservedKeys.get())));
        }
        if (key.isPresent()) {
            queryParams.put("key", Collections.singleton(String.valueOf(key.get())));
        }
        queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName)));
        if (workflowMode.isPresent()) {
            queryParams.put("workflowMode", Collections.singleton(String.valueOf(workflowMode.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getWorkflowTransitionProperties);
    }

    public Single<WorkflowTransitionProperty> updateWorkflowTransitionProperty(Long transitionId, String key, String workflowName, WorkflowTransitionProperty requestBody, Optional<String> workflowMode, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/workflow/transitions/{transitionId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("transitionId", String.valueOf(transitionId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        queryParams.put("key", Collections.singleton(String.valueOf(key)));
        queryParams.put("workflowName", Collections.singleton(String.valueOf(workflowName)));
        if (workflowMode.isPresent()) {
            queryParams.put("workflowMode", Collections.singleton(String.valueOf(workflowMode.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateWorkflowTransitionProperty);
    }
}

