/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.AddFieldBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.MoveFieldBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.ScreenableField;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ScreenTabFieldsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<ScreenableField> returnType_addScreenTabField = new TypeReference<ScreenableField>(){};
    private static final TypeReference<List<ScreenableField>> returnType_getAllScreenTabFields = new TypeReference<List<ScreenableField>>(){};
    private static final TypeReference<Object> returnType_moveScreenTabField = new TypeReference<Object>(){};
    private final RestClient restClient;

    public ScreenTabFieldsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<ScreenableField> addScreenTabField(Long screenId, Long tabId, AddFieldBean addFieldBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(addFieldBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addScreenTabField);
    }

    public Single<List<ScreenableField>> getAllScreenTabFields(Long screenId, Long tabId, Optional<String> projectKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getAllScreenTabFields);
    }

    public Single<Object> moveScreenTabField(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}/move");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(moveFieldBean));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_moveScreenTabField);
    }

    public Completable removeScreenTabField(Long screenId, Long tabId, String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("screenId", String.valueOf(screenId));
        pathParams.put("tabId", String.valueOf(tabId));
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }
}

