/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.Component;
import org.everit.atlassian.restclient.jiracloud.v2.model.ComponentIssuesCount;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageBeanComponentWithIssueCount;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class ProjectComponentsApi {
    private static final String DEFAULT_BASE_PATH = "https://your-domain.atlassian.com";
    private static final TypeReference<Component> returnType_createComponent = new TypeReference<Component>(){};
    private static final TypeReference<Component> returnType_getComponent = new TypeReference<Component>(){};
    private static final TypeReference<ComponentIssuesCount> returnType_getComponentRelatedIssues = new TypeReference<ComponentIssuesCount>(){};
    private static final TypeReference<List<Component>> returnType_getProjectComponents = new TypeReference<List<Component>>(){};
    private static final TypeReference<PageBeanComponentWithIssueCount> returnType_getProjectComponentsPaginated = new TypeReference<PageBeanComponentWithIssueCount>(){};
    private static final TypeReference<Component> returnType_updateComponent = new TypeReference<Component>(){};
    private final RestClient restClient;

    public ProjectComponentsApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Component> createComponent(Component component, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/component");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(component));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createComponent);
    }

    public Completable deleteComponent(String id, Optional<String> moveIssuesTo, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/component/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (moveIssuesTo.isPresent()) {
            queryParams.put("moveIssuesTo", Collections.singleton(String.valueOf(moveIssuesTo.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Component> getComponent(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/component/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getComponent);
    }

    public Single<ComponentIssuesCount> getComponentRelatedIssues(String id, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/component/{id}/relatedIssueCounts");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getComponentRelatedIssues);
    }

    public Single<List<Component>> getProjectComponents(String projectIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/components");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectComponents);
    }

    public Single<PageBeanComponentWithIssueCount> getProjectComponentsPaginated(String projectIdOrKey, Optional<Long> startAt, Optional<Integer> maxResults, Optional<String> orderBy, Optional<String> query, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/project/{projectIdOrKey}/component");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("projectIdOrKey", String.valueOf(projectIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (orderBy.isPresent()) {
            queryParams.put("orderBy", Collections.singleton(String.valueOf(orderBy.get())));
        }
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getProjectComponentsPaginated);
    }

    public Single<Component> updateComponent(String id, Component component, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/component/{id}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("id", String.valueOf(id));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(component));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateComponent);
    }
}

