/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * The IDs of the screens for the screen types of the screen scheme.
 */
@ApiModel(description = "The IDs of the screens for the screen types of the screen scheme.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-10-28T14:12:40.546+01:00[Europe/Prague]")
public class ScreenTypes {
  @JsonProperty("edit")
  private Long edit;

  @JsonProperty("create")
  private Long create;

  @JsonProperty("view")
  private Long view;

  @JsonProperty("default")
  private Long _default;

  public ScreenTypes edit(Long edit) {
    this.edit = edit;
    return this;
  }

   /**
   * The ID of the edit screen.
   * @return edit
  **/
  @ApiModelProperty(value = "The ID of the edit screen.")
  public Long getEdit() {
    return edit;
  }

  public void setEdit(Long edit) {
    this.edit = edit;
  }

  public ScreenTypes create(Long create) {
    this.create = create;
    return this;
  }

   /**
   * The ID of the create screen.
   * @return create
  **/
  @ApiModelProperty(value = "The ID of the create screen.")
  public Long getCreate() {
    return create;
  }

  public void setCreate(Long create) {
    this.create = create;
  }

  public ScreenTypes view(Long view) {
    this.view = view;
    return this;
  }

   /**
   * The ID of the view screen.
   * @return view
  **/
  @ApiModelProperty(value = "The ID of the view screen.")
  public Long getView() {
    return view;
  }

  public void setView(Long view) {
    this.view = view;
  }

  public ScreenTypes _default(Long _default) {
    this._default = _default;
    return this;
  }

   /**
   * The ID of the default screen. Required when creating a screen scheme.
   * @return _default
  **/
  @ApiModelProperty(value = "The ID of the default screen. Required when creating a screen scheme.")
  public Long getDefault() {
    return _default;
  }

  public void setDefault(Long _default) {
    this._default = _default;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScreenTypes screenTypes = (ScreenTypes) o;
    return Objects.equals(this.edit, screenTypes.edit) &&
        Objects.equals(this.create, screenTypes.create) &&
        Objects.equals(this.view, screenTypes.view) &&
        Objects.equals(this._default, screenTypes._default);
  }

  @Override
  public int hashCode() {
    return Objects.hash(edit, create, view, _default);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScreenTypes {\n");
    
    sb.append("    edit: ").append(toIndentedString(edit)).append("\n");
    sb.append("    create: ").append(toIndentedString(create)).append("\n");
    sb.append("    view: ").append(toIndentedString(view)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

