/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTypeScheme;

/**
 * Issue type scheme with a list of the projects that use it.
 */
@ApiModel(description = "Issue type scheme with a list of the projects that use it.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-10-28T14:12:34.799+01:00[Europe/Prague]")
public class IssueTypeSchemeProjects {
  @JsonProperty("issueTypeScheme")
  private IssueTypeScheme issueTypeScheme;

  @JsonProperty("projectIds")
  private List<String> projectIds = new ArrayList<>();

  public IssueTypeSchemeProjects issueTypeScheme(IssueTypeScheme issueTypeScheme) {
    this.issueTypeScheme = issueTypeScheme;
    return this;
  }

   /**
   * Details of an issue type scheme.
   * @return issueTypeScheme
  **/
  @ApiModelProperty(value = "Details of an issue type scheme.")
  public IssueTypeScheme getIssueTypeScheme() {
    return issueTypeScheme;
  }

  public void setIssueTypeScheme(IssueTypeScheme issueTypeScheme) {
    this.issueTypeScheme = issueTypeScheme;
  }

  public IssueTypeSchemeProjects projectIds(List<String> projectIds) {
    this.projectIds = projectIds;
    return this;
  }

  public IssueTypeSchemeProjects addProjectIdsItem(String projectIdsItem) {
    this.projectIds.add(projectIdsItem);
    return this;
  }

   /**
   * The IDs of the projects using the issue type scheme.
   * @return projectIds
  **/
  @ApiModelProperty(required = true, value = "The IDs of the projects using the issue type scheme.")
  public List<String> getProjectIds() {
    return projectIds;
  }

  public void setProjectIds(List<String> projectIds) {
    this.projectIds = projectIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueTypeSchemeProjects issueTypeSchemeProjects = (IssueTypeSchemeProjects) o;
    return Objects.equals(this.issueTypeScheme, issueTypeSchemeProjects.issueTypeScheme) &&
        Objects.equals(this.projectIds, issueTypeSchemeProjects.projectIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issueTypeScheme, projectIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueTypeSchemeProjects {\n");
    
    sb.append("    issueTypeScheme: ").append(toIndentedString(issueTypeScheme)).append("\n");
    sb.append("    projectIds: ").append(toIndentedString(projectIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

