/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.atlassian.restclient.jiracloud.v2.model.IncludedFields;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueTransition;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueUpdateMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.JsonTypeBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Operations;
import org.everit.atlassian.restclient.jiracloud.v2.model.PageOfChangelogs;

/**
 * IssueBean
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-10-28T14:12:34.799+01:00[Europe/Prague]")
public class IssueBean {
  @JsonProperty("expand")
  private String expand;

  @JsonProperty("id")
  private String id;

  @JsonProperty("self")
  private URI self;

  @JsonProperty("key")
  private String key;

  @JsonProperty("renderedFields")
  private Map<String, Object> renderedFields = new HashMap<>();

  @JsonProperty("properties")
  private Map<String, Object> properties = new HashMap<>();

  @JsonProperty("names")
  private Map<String, String> names = new HashMap<>();

  @JsonProperty("schema")
  private Map<String, JsonTypeBean> schema = new HashMap<>();

  @JsonProperty("transitions")
  private List<IssueTransition> transitions = new ArrayList<>();

  @JsonProperty("operations")
  private Operations operations;

  @JsonProperty("editmeta")
  private IssueUpdateMetadata editmeta;

  @JsonProperty("changelog")
  private PageOfChangelogs changelog;

  @JsonProperty("versionedRepresentations")
  private Map<String, Map<String, Object>> versionedRepresentations = new HashMap<>();

  @JsonProperty("fieldsToInclude")
  private IncludedFields fieldsToInclude;

  @JsonProperty("fields")
  private Map<String, Object> fields = new HashMap<>();

   /**
   * Expand options that include additional issue details in the response.
   * @return expand
  **/
  @ApiModelProperty(value = "Expand options that include additional issue details in the response.")
  public String getExpand() {
    return expand;
  }

   /**
   * The ID of the issue.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the issue.")
  public String getId() {
    return id;
  }

   /**
   * The URL of the issue details.
   * @return self
  **/
  @ApiModelProperty(value = "The URL of the issue details.")
  public URI getSelf() {
    return self;
  }

   /**
   * The key of the issue.
   * @return key
  **/
  @ApiModelProperty(value = "The key of the issue.")
  public String getKey() {
    return key;
  }

   /**
   * The rendered value of each field present on the issue.
   * @return renderedFields
  **/
  @ApiModelProperty(value = "The rendered value of each field present on the issue.")
  public Map<String, Object> getRenderedFields() {
    return renderedFields;
  }

   /**
   * Details of the issue properties identified in the request.
   * @return properties
  **/
  @ApiModelProperty(value = "Details of the issue properties identified in the request.")
  public Map<String, Object> getProperties() {
    return properties;
  }

   /**
   * The ID and name of each field present on the issue.
   * @return names
  **/
  @ApiModelProperty(value = "The ID and name of each field present on the issue.")
  public Map<String, String> getNames() {
    return names;
  }

   /**
   * The schema describing each field present on the issue.
   * @return schema
  **/
  @ApiModelProperty(value = "The schema describing each field present on the issue.")
  public Map<String, JsonTypeBean> getSchema() {
    return schema;
  }

   /**
   * The transitions that can be performed on the issue.
   * @return transitions
  **/
  @ApiModelProperty(value = "The transitions that can be performed on the issue.")
  public List<IssueTransition> getTransitions() {
    return transitions;
  }

   /**
   * The operations that can be performed on the issue.
   * @return operations
  **/
  @ApiModelProperty(value = "The operations that can be performed on the issue.")
  public Operations getOperations() {
    return operations;
  }

   /**
   * The metadata for the fields on the issue that can be amended.
   * @return editmeta
  **/
  @ApiModelProperty(value = "The metadata for the fields on the issue that can be amended.")
  public IssueUpdateMetadata getEditmeta() {
    return editmeta;
  }

   /**
   * Details of changelogs associated with the issue.
   * @return changelog
  **/
  @ApiModelProperty(value = "Details of changelogs associated with the issue.")
  public PageOfChangelogs getChangelog() {
    return changelog;
  }

   /**
   * The versions of each field on the issue.
   * @return versionedRepresentations
  **/
  @ApiModelProperty(value = "The versions of each field on the issue.")
  public Map<String, Map<String, Object>> getVersionedRepresentations() {
    return versionedRepresentations;
  }

  public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
    this.fieldsToInclude = fieldsToInclude;
    return this;
  }

   /**
   * Get fieldsToInclude
   * @return fieldsToInclude
  **/
  @ApiModelProperty(value = "")
  public IncludedFields getFieldsToInclude() {
    return fieldsToInclude;
  }

  public void setFieldsToInclude(IncludedFields fieldsToInclude) {
    this.fieldsToInclude = fieldsToInclude;
  }

  public IssueBean fields(Map<String, Object> fields) {
    this.fields = fields;
    return this;
  }

  public IssueBean putFieldsItem(String key, Object fieldsItem) {
    if (this.fields == null) {
      this.fields = new HashMap<>();
    }
    this.fields.put(key, fieldsItem);
    return this;
  }

   /**
   * Get fields
   * @return fields
  **/
  @ApiModelProperty(value = "")
  public Map<String, Object> getFields() {
    return fields;
  }

  public void setFields(Map<String, Object> fields) {
    this.fields = fields;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueBean issueBean = (IssueBean) o;
    return Objects.equals(this.expand, issueBean.expand) &&
        Objects.equals(this.id, issueBean.id) &&
        Objects.equals(this.self, issueBean.self) &&
        Objects.equals(this.key, issueBean.key) &&
        Objects.equals(this.renderedFields, issueBean.renderedFields) &&
        Objects.equals(this.properties, issueBean.properties) &&
        Objects.equals(this.names, issueBean.names) &&
        Objects.equals(this.schema, issueBean.schema) &&
        Objects.equals(this.transitions, issueBean.transitions) &&
        Objects.equals(this.operations, issueBean.operations) &&
        Objects.equals(this.editmeta, issueBean.editmeta) &&
        Objects.equals(this.changelog, issueBean.changelog) &&
        Objects.equals(this.versionedRepresentations, issueBean.versionedRepresentations) &&
        Objects.equals(this.fieldsToInclude, issueBean.fieldsToInclude) &&
        Objects.equals(this.fields, issueBean.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, id, self, key, renderedFields, properties, names, schema, transitions, operations, editmeta, changelog, versionedRepresentations, fieldsToInclude, fields);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueBean {\n");
    
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    renderedFields: ").append(toIndentedString(renderedFields)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    editmeta: ").append(toIndentedString(editmeta)).append("\n");
    sb.append("    changelog: ").append(toIndentedString(changelog)).append("\n");
    sb.append("    versionedRepresentations: ").append(toIndentedString(versionedRepresentations)).append("\n");
    sb.append("    fieldsToInclude: ").append(toIndentedString(fieldsToInclude)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

