/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.AvatarUrlsBean;

@ApiModel(description="User details.")
public class UserDetails {
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="accountId")
    private String accountId;
    @JsonProperty(value="emailAddress")
    private String emailAddress;
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="active")
    private Boolean active;
    @JsonProperty(value="timeZone")
    private String timeZone;
    @JsonProperty(value="accountType")
    private String accountType;

    @ApiModelProperty(value="The URL of the user.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getKey() {
        return this.key;
    }

    public UserDetails accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The accountId of the user, which uniquely identifies the user across all Atlassian products. For example, *384093:32b4d9w0-f6a5-3535-11a3-9c8c88d10192*.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @ApiModelProperty(value="The email address of the user. Depending on the user\u2019s privacy settings, this may be returned as null.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @ApiModelProperty(value="The avatars of the user.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    @ApiModelProperty(value="The display name of the user. Depending on the user\u2019s privacy settings, this may return an alternative value.")
    public String getDisplayName() {
        return this.displayName;
    }

    @ApiModelProperty(value="Whether the user is active.")
    public Boolean getActive() {
        return this.active;
    }

    @ApiModelProperty(value="The time zone specified in the user's profile. Depending on the user\u2019s privacy settings, this may be returned as null.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="The type of account represented by this user. This will be one of 'atlassian' (normal users), 'app' (application user) or 'customer' (Jira Service Desk customer user)")
    public String getAccountType() {
        return this.accountType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDetails userDetails = (UserDetails)o;
        return Objects.equals(this.self, userDetails.self) && Objects.equals(this.name, userDetails.name) && Objects.equals(this.key, userDetails.key) && Objects.equals(this.accountId, userDetails.accountId) && Objects.equals(this.emailAddress, userDetails.emailAddress) && Objects.equals(this.avatarUrls, userDetails.avatarUrls) && Objects.equals(this.displayName, userDetails.displayName) && Objects.equals(this.active, userDetails.active) && Objects.equals(this.timeZone, userDetails.timeZone) && Objects.equals(this.accountType, userDetails.accountType);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.name, this.key, this.accountId, this.emailAddress, this.avatarUrls, this.displayName, this.active, this.timeZone, this.accountType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDetails {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

