/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SharePermissionInputBean {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="groupname")
    private String groupname;
    @JsonProperty(value="projectRoleId")
    private String projectRoleId;

    public SharePermissionInputBean type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the share permission.Specify the type as follows:   *  `group` Share with a group. Specify `groupname` as well.  *  `project` Share with a project. Specify `projectId` as well.  *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.  *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.  *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SharePermissionInputBean projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project to share the filter with. Set `type` to `project`.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public SharePermissionInputBean groupname(String groupname) {
        this.groupname = groupname;
        return this;
    }

    @ApiModelProperty(value="The name of the group to share the filter with. Set `type` to `group`.")
    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public SharePermissionInputBean projectRoleId(String projectRoleId) {
        this.projectRoleId = projectRoleId;
        return this;
    }

    @ApiModelProperty(value="The ID of the project role to share the filter with. Set `type` to `projectRole` and the `projectId` for the project that the role is in.")
    public String getProjectRoleId() {
        return this.projectRoleId;
    }

    public void setProjectRoleId(String projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharePermissionInputBean sharePermissionInputBean = (SharePermissionInputBean)o;
        return Objects.equals((Object)this.type, (Object)sharePermissionInputBean.type) && Objects.equals(this.projectId, sharePermissionInputBean.projectId) && Objects.equals(this.groupname, sharePermissionInputBean.groupname) && Objects.equals(this.projectRoleId, sharePermissionInputBean.projectRoleId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.projectId, this.groupname, this.projectRoleId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharePermissionInputBean {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    groupname: ").append(this.toIndentedString(this.groupname)).append("\n");
        sb.append("    projectRoleId: ").append(this.toIndentedString(this.projectRoleId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PROJECT("project"),
        GROUP("group"),
        PROJECTROLE("projectRole"),
        GLOBAL("global"),
        AUTHENTICATED("authenticated");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

