/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.everit.atlassian.restclient.jiracloud.v3.model.AvatarUrlsBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.Component;
import org.everit.atlassian.restclient.jiracloud.v3.model.Hierarchy;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueTypeBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectCategory;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectPermissions;
import org.everit.atlassian.restclient.jiracloud.v3.model.User;
import org.everit.atlassian.restclient.jiracloud.v3.model.Version;

@ApiModel(description="Details about a project.")
public class Project {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="lead")
    private User lead;
    @JsonProperty(value="components")
    private List<Component> components = new ArrayList<Component>();
    @JsonProperty(value="issueTypes")
    private List<IssueTypeBean> issueTypes = new ArrayList<IssueTypeBean>();
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="versions")
    private List<Version> versions = new ArrayList<Version>();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="roles")
    private Map<String, URI> roles = new HashMap<String, URI>();
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="projectCategory")
    private ProjectCategory projectCategory;
    @JsonProperty(value="projectTypeKey")
    private ProjectTypeKeyEnum projectTypeKey;
    @JsonProperty(value="simplified")
    private Boolean simplified;
    @JsonProperty(value="style")
    private StyleEnum style;
    @JsonProperty(value="isPrivate")
    private Boolean isPrivate;
    @JsonProperty(value="issueTypeHierarchy")
    private Hierarchy issueTypeHierarchy;
    @JsonProperty(value="permissions")
    private ProjectPermissions permissions;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="uuid")
    private UUID uuid;

    @ApiModelProperty(value="Expand options that include additional project details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="The URL of the project details.")
    public URI getSelf() {
        return this.self;
    }

    public Project id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the project.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The key of the project.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="A brief description of the project.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The username of the project lead.")
    public User getLead() {
        return this.lead;
    }

    @ApiModelProperty(value="List of the components contained in the project.")
    public List<Component> getComponents() {
        return this.components;
    }

    @ApiModelProperty(value="List of the issue types available in the project.")
    public List<IssueTypeBean> getIssueTypes() {
        return this.issueTypes;
    }

    @ApiModelProperty(value="A link to information about this project, such as project documentation.")
    public String getUrl() {
        return this.url;
    }

    public Project email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="An email address associated with the project.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="The default assignee when creating issues for this project.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    @ApiModelProperty(value="The versions defined in the project. For more information, see [Create version](#api-rest-api-3-version-post).")
    public List<Version> getVersions() {
        return this.versions;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The name and self URL for each role defined in the project. For more information, see [Create project role](#api-rest-api-3-role-post).")
    public Map<String, URI> getRoles() {
        return this.roles;
    }

    @ApiModelProperty(value="The URLs of the project's avatars.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    @ApiModelProperty(value="The category the project belongs to.")
    public ProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    @ApiModelProperty(value="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.")
    public ProjectTypeKeyEnum getProjectTypeKey() {
        return this.projectTypeKey;
    }

    @ApiModelProperty(value="Indicates whether the project is simplified.")
    public Boolean getSimplified() {
        return this.simplified;
    }

    @ApiModelProperty(value="The type of the project.")
    public StyleEnum getStyle() {
        return this.style;
    }

    @ApiModelProperty(value="Indicates whether the project is private.")
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    @ApiModelProperty(value="The issue type hierarchy for the project")
    public Hierarchy getIssueTypeHierarchy() {
        return this.issueTypeHierarchy;
    }

    @ApiModelProperty(value="User permissions on the project")
    public ProjectPermissions getPermissions() {
        return this.permissions;
    }

    @ApiModelProperty(value="Map of project properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="unique ID for next-gen projects")
    public UUID getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.expand, project.expand) && Objects.equals(this.self, project.self) && Objects.equals(this.id, project.id) && Objects.equals(this.key, project.key) && Objects.equals(this.description, project.description) && Objects.equals(this.lead, project.lead) && Objects.equals(this.components, project.components) && Objects.equals(this.issueTypes, project.issueTypes) && Objects.equals(this.url, project.url) && Objects.equals(this.email, project.email) && Objects.equals((Object)this.assigneeType, (Object)project.assigneeType) && Objects.equals(this.versions, project.versions) && Objects.equals(this.name, project.name) && Objects.equals(this.roles, project.roles) && Objects.equals(this.avatarUrls, project.avatarUrls) && Objects.equals(this.projectCategory, project.projectCategory) && Objects.equals((Object)this.projectTypeKey, (Object)project.projectTypeKey) && Objects.equals(this.simplified, project.simplified) && Objects.equals((Object)this.style, (Object)project.style) && Objects.equals(this.isPrivate, project.isPrivate) && Objects.equals(this.issueTypeHierarchy, project.issueTypeHierarchy) && Objects.equals(this.permissions, project.permissions) && Objects.equals(this.properties, project.properties) && Objects.equals(this.uuid, project.uuid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expand, this.self, this.id, this.key, this.description, this.lead, this.components, this.issueTypes, this.url, this.email, this.assigneeType, this.versions, this.name, this.roles, this.avatarUrls, this.projectCategory, this.projectTypeKey, this.simplified, this.style, this.isPrivate, this.issueTypeHierarchy, this.permissions, this.properties, this.uuid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    projectCategory: ").append(this.toIndentedString(this.projectCategory)).append("\n");
        sb.append("    projectTypeKey: ").append(this.toIndentedString((Object)this.projectTypeKey)).append("\n");
        sb.append("    simplified: ").append(this.toIndentedString(this.simplified)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    isPrivate: ").append(this.toIndentedString(this.isPrivate)).append("\n");
        sb.append("    issueTypeHierarchy: ").append(this.toIndentedString(this.issueTypeHierarchy)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StyleEnum {
        CLASSIC("CLASSIC"),
        NEXTGEN("NEXTGEN"),
        NEXT_GEN("next-gen");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProjectTypeKeyEnum {
        SOFTWARE("software"),
        SERVICE_DESK("service_desk"),
        BUSINESS("business");

        private String value;

        private ProjectTypeKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTypeKeyEnum fromValue(String value) {
            for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AssigneeTypeEnum {
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

