/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;

@ApiModel(description="Details about a component with a count of the issues it contains.")
public class ComponentWithIssueCount {
    @JsonProperty(value="issueCount")
    private Long issueCount;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="assigneeType")
    private AssigneeTypeEnum assigneeType;
    @JsonProperty(value="lead")
    private User lead;
    @JsonProperty(value="projectId")
    private Long projectId;
    @JsonProperty(value="realAssignee")
    private User realAssignee;
    @JsonProperty(value="isAssigneeTypeValid")
    private Boolean isAssigneeTypeValid;
    @JsonProperty(value="assignee")
    private User assignee;
    @JsonProperty(value="realAssigneeType")
    private RealAssigneeTypeEnum realAssigneeType;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="id")
    private String id;

    @ApiModelProperty(value="Count of issues for the component.")
    public Long getIssueCount() {
        return this.issueCount;
    }

    @ApiModelProperty(value="The description for the component.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The URL for this count of the issues contained in the component.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="The key of the project to which the component is assigned.")
    public String getProject() {
        return this.project;
    }

    @ApiModelProperty(value="The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Takes the following values:   *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.  *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.  *  `UNASSIGNED` an assignee is not set for issues created with this component.  *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.")
    public AssigneeTypeEnum getAssigneeType() {
        return this.assigneeType;
    }

    public ComponentWithIssueCount lead(User lead) {
        this.lead = lead;
        return this;
    }

    @ApiModelProperty(value="The user details for the component's lead user.")
    public User getLead() {
        return this.lead;
    }

    public void setLead(User lead) {
        this.lead = lead;
    }

    @ApiModelProperty(value="Not used.")
    public Long getProjectId() {
        return this.projectId;
    }

    public ComponentWithIssueCount realAssignee(User realAssignee) {
        this.realAssignee = realAssignee;
        return this;
    }

    @ApiModelProperty(value="The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.")
    public User getRealAssignee() {
        return this.realAssignee;
    }

    public void setRealAssignee(User realAssignee) {
        this.realAssignee = realAssignee;
    }

    @ApiModelProperty(value="Indicates whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.")
    public Boolean getIsAssigneeTypeValid() {
        return this.isAssigneeTypeValid;
    }

    public ComponentWithIssueCount assignee(User assignee) {
        this.assignee = assignee;
        return this;
    }

    @ApiModelProperty(value="The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.")
    public User getAssignee() {
        return this.assignee;
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    @ApiModelProperty(value="The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:   *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.  *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.  *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.  *  `PROJECT_DEFAULT` when none of the preceding cases are true.")
    public RealAssigneeTypeEnum getRealAssigneeType() {
        return this.realAssigneeType;
    }

    @ApiModelProperty(value="The name for the component.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The unique identifier for the component.")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentWithIssueCount componentWithIssueCount = (ComponentWithIssueCount)o;
        return Objects.equals(this.issueCount, componentWithIssueCount.issueCount) && Objects.equals(this.description, componentWithIssueCount.description) && Objects.equals(this.self, componentWithIssueCount.self) && Objects.equals(this.project, componentWithIssueCount.project) && Objects.equals((Object)this.assigneeType, (Object)componentWithIssueCount.assigneeType) && Objects.equals(this.lead, componentWithIssueCount.lead) && Objects.equals(this.projectId, componentWithIssueCount.projectId) && Objects.equals(this.realAssignee, componentWithIssueCount.realAssignee) && Objects.equals(this.isAssigneeTypeValid, componentWithIssueCount.isAssigneeTypeValid) && Objects.equals(this.assignee, componentWithIssueCount.assignee) && Objects.equals((Object)this.realAssigneeType, (Object)componentWithIssueCount.realAssigneeType) && Objects.equals(this.name, componentWithIssueCount.name) && Objects.equals(this.id, componentWithIssueCount.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issueCount, this.description, this.self, this.project, this.assigneeType, this.lead, this.projectId, this.realAssignee, this.isAssigneeTypeValid, this.assignee, this.realAssigneeType, this.name, this.id});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComponentWithIssueCount {\n");
        sb.append("    issueCount: ").append(this.toIndentedString(this.issueCount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    assigneeType: ").append(this.toIndentedString((Object)this.assigneeType)).append("\n");
        sb.append("    lead: ").append(this.toIndentedString(this.lead)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    realAssignee: ").append(this.toIndentedString(this.realAssignee)).append("\n");
        sb.append("    isAssigneeTypeValid: ").append(this.toIndentedString(this.isAssigneeTypeValid)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    realAssigneeType: ").append(this.toIndentedString((Object)this.realAssigneeType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RealAssigneeTypeEnum {
        PROJECT_DEFAULT("PROJECT_DEFAULT"),
        COMPONENT_LEAD("COMPONENT_LEAD"),
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private RealAssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RealAssigneeTypeEnum fromValue(String value) {
            for (RealAssigneeTypeEnum b : RealAssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AssigneeTypeEnum {
        PROJECT_DEFAULT("PROJECT_DEFAULT"),
        COMPONENT_LEAD("COMPONENT_LEAD"),
        PROJECT_LEAD("PROJECT_LEAD"),
        UNASSIGNED("UNASSIGNED");

        private String value;

        private AssigneeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssigneeTypeEnum fromValue(String value) {
            for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

