/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreatedIssue;
import org.everit.atlassian.restclient.jiracloud.v2.model.CreatedIssues;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueCreateMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssuePickerSuggestions;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueUpdateDetails;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssueUpdateMetadata;
import org.everit.atlassian.restclient.jiracloud.v2.model.IssuesUpdateBean;
import org.everit.atlassian.restclient.jiracloud.v2.model.Notification;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLink;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLinkIdentifies;
import org.everit.atlassian.restclient.jiracloud.v2.model.RemoteIssueLinkRequest;
import org.everit.atlassian.restclient.jiracloud.v2.model.Transitions;
import org.everit.atlassian.restclient.jiracloud.v2.model.User;
import org.everit.atlassian.restclient.jiracloud.v2.model.Votes;
import org.everit.atlassian.restclient.jiracloud.v2.model.Watchers;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class IssueApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<Object> returnType_addVote = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_addWatcher = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_assignIssue = new TypeReference<Object>(){};
    private static final TypeReference<CreatedIssue> returnType_createIssue = new TypeReference<CreatedIssue>(){};
    private static final TypeReference<CreatedIssues> returnType_createIssues = new TypeReference<CreatedIssues>(){};
    private static final TypeReference<RemoteIssueLinkIdentifies> returnType_createOrUpdateRemoteIssueLink = new TypeReference<RemoteIssueLinkIdentifies>(){};
    private static final TypeReference<Object> returnType_doTransition = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_editIssue = new TypeReference<Object>(){};
    private static final TypeReference<IssueCreateMetadata> returnType_getCreateIssueMeta = new TypeReference<IssueCreateMetadata>(){};
    private static final TypeReference<IssueUpdateMetadata> returnType_getEditIssueMeta = new TypeReference<IssueUpdateMetadata>(){};
    private static final TypeReference<IssueBean> returnType_getIssue = new TypeReference<IssueBean>(){};
    private static final TypeReference<IssuePickerSuggestions> returnType_getIssuePickerResource = new TypeReference<IssuePickerSuggestions>(){};
    private static final TypeReference<Watchers> returnType_getIssueWatchers = new TypeReference<Watchers>(){};
    private static final TypeReference<RemoteIssueLink> returnType_getRemoteIssueLinkById = new TypeReference<RemoteIssueLink>(){};
    private static final TypeReference<RemoteIssueLink> returnType_getRemoteIssueLinks = new TypeReference<RemoteIssueLink>(){};
    private static final TypeReference<Transitions> returnType_getTransitions = new TypeReference<Transitions>(){};
    private static final TypeReference<Votes> returnType_getVotes = new TypeReference<Votes>(){};
    private static final TypeReference<Object> returnType_notify = new TypeReference<Object>(){};
    private static final TypeReference<Object> returnType_updateRemoteIssueLink = new TypeReference<Object>(){};
    private final RestClient restClient;

    public IssueApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<Object> addVote(String issueIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/votes");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addVote);
    }

    public Single<Object> addWatcher(String issueIdOrKey, String body, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/watchers");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_addWatcher);
    }

    public Single<Object> assignIssue(String issueIdOrKey, User user, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/assignee");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(user));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_assignIssue);
    }

    public Single<CreatedIssue> createIssue(IssueUpdateDetails requestBody, Optional<Boolean> updateHistory, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (updateHistory.isPresent()) {
            queryParams.put("updateHistory", Collections.singleton(String.valueOf(updateHistory.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssue);
    }

    public Single<CreatedIssues> createIssues(IssuesUpdateBean requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/bulk");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createIssues);
    }

    public Single<RemoteIssueLinkIdentifies> createOrUpdateRemoteIssueLink(String issueIdOrKey, RemoteIssueLinkRequest requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createOrUpdateRemoteIssueLink);
    }

    public Completable deleteIssue(String issueIdOrKey, Optional<String> deleteSubtasks, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (deleteSubtasks.isPresent()) {
            queryParams.put("deleteSubtasks", Collections.singleton(String.valueOf(deleteSubtasks.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteRemoteIssueLinkByGlobalId(String issueIdOrKey, Optional<String> globalId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (globalId.isPresent()) {
            queryParams.put("globalId", Collections.singleton(String.valueOf(globalId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable deleteRemoteIssueLinkById(String issueIdOrKey, String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Object> doTransition(String issueIdOrKey, IssueUpdateDetails requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/transitions");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_doTransition);
    }

    public Single<Object> editIssue(String issueIdOrKey, IssueUpdateDetails requestBody, Optional<Boolean> notifyUsers, Optional<Boolean> overrideScreenSecurity, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (notifyUsers.isPresent()) {
            queryParams.put("notifyUsers", Collections.singleton(String.valueOf(notifyUsers.get())));
        }
        if (overrideScreenSecurity.isPresent()) {
            queryParams.put("overrideScreenSecurity", Collections.singleton(String.valueOf(overrideScreenSecurity.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_editIssue);
    }

    public Single<IssueCreateMetadata> getCreateIssueMeta(Optional<List<String>> projectIds, Optional<List<String>> projectKeys, Optional<List<String>> issuetypeIds, Optional<List<String>> issuetypeNames, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/createmeta");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (projectIds.isPresent()) {
            queryParams.put("projectIds", RestClientUtil.objectCollectionToStringCollection((Collection)projectIds.get()));
        }
        if (projectKeys.isPresent()) {
            queryParams.put("projectKeys", RestClientUtil.objectCollectionToStringCollection((Collection)projectKeys.get()));
        }
        if (issuetypeIds.isPresent()) {
            queryParams.put("issuetypeIds", RestClientUtil.objectCollectionToStringCollection((Collection)issuetypeIds.get()));
        }
        if (issuetypeNames.isPresent()) {
            queryParams.put("issuetypeNames", RestClientUtil.objectCollectionToStringCollection((Collection)issuetypeNames.get()));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getCreateIssueMeta);
    }

    public Single<IssueUpdateMetadata> getEditIssueMeta(String issueIdOrKey, Optional<Boolean> overrideScreenSecurity, Optional<Boolean> overrideEditableFlag, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/editmeta");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (overrideScreenSecurity.isPresent()) {
            queryParams.put("overrideScreenSecurity", Collections.singleton(String.valueOf(overrideScreenSecurity.get())));
        }
        if (overrideEditableFlag.isPresent()) {
            queryParams.put("overrideEditableFlag", Collections.singleton(String.valueOf(overrideEditableFlag.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getEditIssueMeta);
    }

    public Single<IssueBean> getIssue(String issueIdOrKey, Optional<List<String>> fields, Optional<Boolean> fieldsByKeys, Optional<String> expand, Optional<List<String>> properties, Optional<Boolean> updateHistory, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (fields.isPresent()) {
            queryParams.put("fields", RestClientUtil.objectCollectionToStringCollection((Collection)fields.get()));
        }
        if (fieldsByKeys.isPresent()) {
            queryParams.put("fieldsByKeys", Collections.singleton(String.valueOf(fieldsByKeys.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (properties.isPresent()) {
            queryParams.put("properties", RestClientUtil.objectCollectionToStringCollection((Collection)properties.get()));
        }
        if (updateHistory.isPresent()) {
            queryParams.put("updateHistory", Collections.singleton(String.valueOf(updateHistory.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssue);
    }

    public Single<IssuePickerSuggestions> getIssuePickerResource(Optional<String> query, Optional<String> currentJQL, Optional<String> currentIssueKey, Optional<String> currentProjectId, Optional<Boolean> showSubTasks, Optional<Boolean> showSubTaskParent, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/picker");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (currentJQL.isPresent()) {
            queryParams.put("currentJQL", Collections.singleton(String.valueOf(currentJQL.get())));
        }
        if (currentIssueKey.isPresent()) {
            queryParams.put("currentIssueKey", Collections.singleton(String.valueOf(currentIssueKey.get())));
        }
        if (currentProjectId.isPresent()) {
            queryParams.put("currentProjectId", Collections.singleton(String.valueOf(currentProjectId.get())));
        }
        if (showSubTasks.isPresent()) {
            queryParams.put("showSubTasks", Collections.singleton(String.valueOf(showSubTasks.get())));
        }
        if (showSubTaskParent.isPresent()) {
            queryParams.put("showSubTaskParent", Collections.singleton(String.valueOf(showSubTaskParent.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssuePickerResource);
    }

    public Single<Watchers> getIssueWatchers(String issueIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/watchers");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getIssueWatchers);
    }

    public Single<RemoteIssueLink> getRemoteIssueLinkById(String issueIdOrKey, String linkId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getRemoteIssueLinkById);
    }

    public Single<RemoteIssueLink> getRemoteIssueLinks(String issueIdOrKey, Optional<String> globalId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (globalId.isPresent()) {
            queryParams.put("globalId", Collections.singleton(String.valueOf(globalId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getRemoteIssueLinks);
    }

    public Single<Transitions> getTransitions(String issueIdOrKey, Optional<String> expand, Optional<String> transitionId, Optional<Boolean> skipRemoteOnlyCondition, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/transitions");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        if (transitionId.isPresent()) {
            queryParams.put("transitionId", Collections.singleton(String.valueOf(transitionId.get())));
        }
        if (skipRemoteOnlyCondition.isPresent()) {
            queryParams.put("skipRemoteOnlyCondition", Collections.singleton(String.valueOf(skipRemoteOnlyCondition.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getTransitions);
    }

    public Single<Votes> getVotes(String issueIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/votes");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getVotes);
    }

    public Single<Object> notify(String issueIdOrKey, Notification requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/notify");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_notify);
    }

    public Completable removeVote(String issueIdOrKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/votes");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable removeWatcher(String issueIdOrKey, Optional<String> username, Optional<String> accountId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/watchers");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Object> updateRemoteIssueLink(String issueIdOrKey, String linkId, RemoteIssueLinkRequest requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("issueIdOrKey", String.valueOf(issueIdOrKey));
        pathParams.put("linkId", String.valueOf(linkId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_updateRemoteIssueLink);
    }
}

