/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.util;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializerBase;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.everit.http.restclient.JSONObjectMapper;
import org.everit.http.restclient.TypeReference;

public class JiraCloudJSONObjectMapper
implements JSONObjectMapper {
    public static final JSONObjectMapper INSTANCE;
    public static final DateTimeFormatter JIRA_CLOUD_DATETIME_FORMATTER;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public JiraCloudJSONObjectMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer(new OffsetDateTimeDeserializer(), false));
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeSerializer());
        this.objectMapper.registerModule((Module)javaTimeModule);
        this.objectMapper.registerModule((Module)new Jdk8Module());
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }

    public <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)this.objectMapper.convertValue(fromValue, new PreDefinedTypeReference<T>(toValueTypeRef));
    }

    public <T> T fromJSON(String json, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T fromJSON(String json, TypeReference<T> valueTypeReference) {
        try {
            return (T)this.objectMapper.readValue(json, new PreDefinedTypeReference<T>(valueTypeReference));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toJSON(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JIRA_CLOUD_DATETIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ")).toFormatter();
        INSTANCE = new JiraCloudJSONObjectMapper();
    }

    private static class PreDefinedTypeReference<T>
    extends com.fasterxml.jackson.core.type.TypeReference<T> {
        private Type valueType;

        PreDefinedTypeReference(TypeReference<T> typeReference) {
            this.valueType = typeReference.getType();
        }

        public Type getType() {
            return this.valueType;
        }
    }

    private static class OffsetDateTimeSerializer
    extends InstantSerializerBase<OffsetDateTime> {
        private static final long serialVersionUID = 998887473102198507L;

        protected OffsetDateTimeSerializer() {
            super(OffsetDateTime.class, dt -> dt.toInstant().toEpochMilli(), OffsetDateTime::toEpochSecond, OffsetDateTime::getNano, JIRA_CLOUD_DATETIME_FORMATTER);
        }

        protected OffsetDateTimeSerializer(OffsetDateTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter) {
            super((InstantSerializerBase)base, useTimestamp, useNanoseconds, formatter);
        }

        protected OffsetDateTimeSerializer(OffsetDateTimeSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
            this(base, useTimestamp, null, JIRA_CLOUD_DATETIME_FORMATTER);
        }

        protected OffsetDateTimeSerializer withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
            return new OffsetDateTimeSerializer(this, false, false, JIRA_CLOUD_DATETIME_FORMATTER);
        }

        protected OffsetDateTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
            return new OffsetDateTimeSerializer(this, false, formatter);
        }
    }

    private static class OffsetDateTimeDeserializer
    extends InstantDeserializer<OffsetDateTime> {
        private static final long serialVersionUID = 4935425608165819930L;

        OffsetDateTimeDeserializer() {
            super(OffsetDateTime.class, JIRA_CLOUD_DATETIME_FORMATTER, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), false);
        }

        public OffsetDateTimeDeserializer(InstantDeserializer<OffsetDateTime> base, Boolean adjustToContextTimezoneOverride) {
            super(base, adjustToContextTimezoneOverride);
        }
    }
}

