/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.HealthCheckResult;

/**
 * Details about the Jira instance.
 */
@ApiModel(description = "Details about the Jira instance.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-09-05T12:17:37.034+02:00[Europe/Prague]")
public class ServerInformation {
  @JsonProperty("baseUrl")
  private String baseUrl;

  @JsonProperty("version")
  private String version;

  @JsonProperty("versionNumbers")
  private List<Integer> versionNumbers = new ArrayList<>();

  @JsonProperty("deploymentType")
  private String deploymentType;

  @JsonProperty("buildNumber")
  private Integer buildNumber;

  @JsonProperty("buildDate")
  private OffsetDateTime buildDate;

  @JsonProperty("serverTime")
  private OffsetDateTime serverTime;

  @JsonProperty("scmInfo")
  private String scmInfo;

  @JsonProperty("serverTitle")
  private String serverTitle;

  @JsonProperty("healthChecks")
  private List<HealthCheckResult> healthChecks = new ArrayList<>();

  public ServerInformation baseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
    return this;
  }

   /**
   * The base URL of the Jira instance.
   * @return baseUrl
  **/
  @ApiModelProperty(value = "The base URL of the Jira instance.")
  public String getBaseUrl() {
    return baseUrl;
  }

  public void setBaseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
  }

  public ServerInformation version(String version) {
    this.version = version;
    return this;
  }

   /**
   * The version of Jira.
   * @return version
  **/
  @ApiModelProperty(value = "The version of Jira.")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public ServerInformation versionNumbers(List<Integer> versionNumbers) {
    this.versionNumbers = versionNumbers;
    return this;
  }

  public ServerInformation addVersionNumbersItem(Integer versionNumbersItem) {
    if (this.versionNumbers == null) {
      this.versionNumbers = new ArrayList<>();
    }
    this.versionNumbers.add(versionNumbersItem);
    return this;
  }

   /**
   * The major, minor, and revision version numbers of the Jira version.
   * @return versionNumbers
  **/
  @ApiModelProperty(value = "The major, minor, and revision version numbers of the Jira version.")
  public List<Integer> getVersionNumbers() {
    return versionNumbers;
  }

  public void setVersionNumbers(List<Integer> versionNumbers) {
    this.versionNumbers = versionNumbers;
  }

  public ServerInformation deploymentType(String deploymentType) {
    this.deploymentType = deploymentType;
    return this;
  }

   /**
   * The type of server deployment. This is always returned as *Cloud*.
   * @return deploymentType
  **/
  @ApiModelProperty(value = "The type of server deployment. This is always returned as *Cloud*.")
  public String getDeploymentType() {
    return deploymentType;
  }

  public void setDeploymentType(String deploymentType) {
    this.deploymentType = deploymentType;
  }

  public ServerInformation buildNumber(Integer buildNumber) {
    this.buildNumber = buildNumber;
    return this;
  }

   /**
   * The build number of the Jira version.
   * @return buildNumber
  **/
  @ApiModelProperty(value = "The build number of the Jira version.")
  public Integer getBuildNumber() {
    return buildNumber;
  }

  public void setBuildNumber(Integer buildNumber) {
    this.buildNumber = buildNumber;
  }

  public ServerInformation buildDate(OffsetDateTime buildDate) {
    this.buildDate = buildDate;
    return this;
  }

   /**
   * The timestamp when the Jira version was built.
   * @return buildDate
  **/
  @ApiModelProperty(value = "The timestamp when the Jira version was built.")
  public OffsetDateTime getBuildDate() {
    return buildDate;
  }

  public void setBuildDate(OffsetDateTime buildDate) {
    this.buildDate = buildDate;
  }

  public ServerInformation serverTime(OffsetDateTime serverTime) {
    this.serverTime = serverTime;
    return this;
  }

   /**
   * The time in Jira when this request was responded to.
   * @return serverTime
  **/
  @ApiModelProperty(value = "The time in Jira when this request was responded to.")
  public OffsetDateTime getServerTime() {
    return serverTime;
  }

  public void setServerTime(OffsetDateTime serverTime) {
    this.serverTime = serverTime;
  }

  public ServerInformation scmInfo(String scmInfo) {
    this.scmInfo = scmInfo;
    return this;
  }

   /**
   * The unique identifier of the Jira version.
   * @return scmInfo
  **/
  @ApiModelProperty(value = "The unique identifier of the Jira version.")
  public String getScmInfo() {
    return scmInfo;
  }

  public void setScmInfo(String scmInfo) {
    this.scmInfo = scmInfo;
  }

  public ServerInformation serverTitle(String serverTitle) {
    this.serverTitle = serverTitle;
    return this;
  }

   /**
   * The name of the Jira instance.
   * @return serverTitle
  **/
  @ApiModelProperty(value = "The name of the Jira instance.")
  public String getServerTitle() {
    return serverTitle;
  }

  public void setServerTitle(String serverTitle) {
    this.serverTitle = serverTitle;
  }

  public ServerInformation healthChecks(List<HealthCheckResult> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  public ServerInformation addHealthChecksItem(HealthCheckResult healthChecksItem) {
    if (this.healthChecks == null) {
      this.healthChecks = new ArrayList<>();
    }
    this.healthChecks.add(healthChecksItem);
    return this;
  }

   /**
   * Jira instance health check results. Deprecated and no longer returned.
   * @return healthChecks
  **/
  @ApiModelProperty(value = "Jira instance health check results. Deprecated and no longer returned.")
  public List<HealthCheckResult> getHealthChecks() {
    return healthChecks;
  }

  public void setHealthChecks(List<HealthCheckResult> healthChecks) {
    this.healthChecks = healthChecks;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerInformation serverInformation = (ServerInformation) o;
    return Objects.equals(this.baseUrl, serverInformation.baseUrl) &&
        Objects.equals(this.version, serverInformation.version) &&
        Objects.equals(this.versionNumbers, serverInformation.versionNumbers) &&
        Objects.equals(this.deploymentType, serverInformation.deploymentType) &&
        Objects.equals(this.buildNumber, serverInformation.buildNumber) &&
        Objects.equals(this.buildDate, serverInformation.buildDate) &&
        Objects.equals(this.serverTime, serverInformation.serverTime) &&
        Objects.equals(this.scmInfo, serverInformation.scmInfo) &&
        Objects.equals(this.serverTitle, serverInformation.serverTitle) &&
        Objects.equals(this.healthChecks, serverInformation.healthChecks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(baseUrl, version, versionNumbers, deploymentType, buildNumber, buildDate, serverTime, scmInfo, serverTitle, healthChecks);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerInformation {\n");
    
    sb.append("    baseUrl: ").append(toIndentedString(baseUrl)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    versionNumbers: ").append(toIndentedString(versionNumbers)).append("\n");
    sb.append("    deploymentType: ").append(toIndentedString(deploymentType)).append("\n");
    sb.append("    buildNumber: ").append(toIndentedString(buildNumber)).append("\n");
    sb.append("    buildDate: ").append(toIndentedString(buildDate)).append("\n");
    sb.append("    serverTime: ").append(toIndentedString(serverTime)).append("\n");
    sb.append("    scmInfo: ").append(toIndentedString(scmInfo)).append("\n");
    sb.append("    serverTitle: ").append(toIndentedString(serverTitle)).append("\n");
    sb.append("    healthChecks: ").append(toIndentedString(healthChecks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

