/*
 * Copyright © 2011 Everit Kft. (http://www.everit.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.everit.atlassian.restclient.jiracloud.v3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.everit.atlassian.restclient.jiracloud.v3.model.FieldReferenceData;
import org.everit.atlassian.restclient.jiracloud.v3.model.FunctionReferenceData;

/**
 * Lists of JQL reference data.
 */
@ApiModel(description = "Lists of JQL reference data.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-09-05T12:17:37.034+02:00[Europe/Prague]")
public class JQLReferenceData {
  @JsonProperty("visibleFieldNames")
  private List<FieldReferenceData> visibleFieldNames = new ArrayList<>();

  @JsonProperty("visibleFunctionNames")
  private List<FunctionReferenceData> visibleFunctionNames = new ArrayList<>();

  @JsonProperty("jqlReservedWords")
  private List<String> jqlReservedWords = new ArrayList<>();

  public JQLReferenceData visibleFieldNames(List<FieldReferenceData> visibleFieldNames) {
    this.visibleFieldNames = visibleFieldNames;
    return this;
  }

  public JQLReferenceData addVisibleFieldNamesItem(FieldReferenceData visibleFieldNamesItem) {
    if (this.visibleFieldNames == null) {
      this.visibleFieldNames = new ArrayList<>();
    }
    this.visibleFieldNames.add(visibleFieldNamesItem);
    return this;
  }

   /**
   * List of fields usable in JQL queries.
   * @return visibleFieldNames
  **/
  @ApiModelProperty(value = "List of fields usable in JQL queries.")
  public List<FieldReferenceData> getVisibleFieldNames() {
    return visibleFieldNames;
  }

  public void setVisibleFieldNames(List<FieldReferenceData> visibleFieldNames) {
    this.visibleFieldNames = visibleFieldNames;
  }

  public JQLReferenceData visibleFunctionNames(List<FunctionReferenceData> visibleFunctionNames) {
    this.visibleFunctionNames = visibleFunctionNames;
    return this;
  }

  public JQLReferenceData addVisibleFunctionNamesItem(FunctionReferenceData visibleFunctionNamesItem) {
    if (this.visibleFunctionNames == null) {
      this.visibleFunctionNames = new ArrayList<>();
    }
    this.visibleFunctionNames.add(visibleFunctionNamesItem);
    return this;
  }

   /**
   * List of functions usable in JQL queries.
   * @return visibleFunctionNames
  **/
  @ApiModelProperty(value = "List of functions usable in JQL queries.")
  public List<FunctionReferenceData> getVisibleFunctionNames() {
    return visibleFunctionNames;
  }

  public void setVisibleFunctionNames(List<FunctionReferenceData> visibleFunctionNames) {
    this.visibleFunctionNames = visibleFunctionNames;
  }

  public JQLReferenceData jqlReservedWords(List<String> jqlReservedWords) {
    this.jqlReservedWords = jqlReservedWords;
    return this;
  }

  public JQLReferenceData addJqlReservedWordsItem(String jqlReservedWordsItem) {
    if (this.jqlReservedWords == null) {
      this.jqlReservedWords = new ArrayList<>();
    }
    this.jqlReservedWords.add(jqlReservedWordsItem);
    return this;
  }

   /**
   * List of JQL query reserved words.
   * @return jqlReservedWords
  **/
  @ApiModelProperty(value = "List of JQL query reserved words.")
  public List<String> getJqlReservedWords() {
    return jqlReservedWords;
  }

  public void setJqlReservedWords(List<String> jqlReservedWords) {
    this.jqlReservedWords = jqlReservedWords;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JQLReferenceData jqLReferenceData = (JQLReferenceData) o;
    return Objects.equals(this.visibleFieldNames, jqLReferenceData.visibleFieldNames) &&
        Objects.equals(this.visibleFunctionNames, jqLReferenceData.visibleFunctionNames) &&
        Objects.equals(this.jqlReservedWords, jqLReferenceData.jqlReservedWords);
  }

  @Override
  public int hashCode() {
    return Objects.hash(visibleFieldNames, visibleFunctionNames, jqlReservedWords);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JQLReferenceData {\n");
    
    sb.append("    visibleFieldNames: ").append(toIndentedString(visibleFieldNames)).append("\n");
    sb.append("    visibleFunctionNames: ").append(toIndentedString(visibleFunctionNames)).append("\n");
    sb.append("    jqlReservedWords: ").append(toIndentedString(jqlReservedWords)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

