/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details about the time tracking provider.")
public class TimeTrackingProvider {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="url")
    private String url;

    public TimeTrackingProvider key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="The key for the time tracking provider. For example, *JIRA*.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public TimeTrackingProvider name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the time tracking provider. For example, *JIRA provided time tracking*.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The URL of the configuration page for the time tracking provider app. For example, *_/example/config/url*. This property is only returned if the `adminPageKey` property is set in the module descriptor of the time tracking provider app.")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeTrackingProvider timeTrackingProvider = (TimeTrackingProvider)o;
        return Objects.equals(this.key, timeTrackingProvider.key) && Objects.equals(this.name, timeTrackingProvider.name) && Objects.equals(this.url, timeTrackingProvider.url);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeTrackingProvider {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

