/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JsonTypeBean;

@ApiModel(description="The metadata describing an issue field.")
public class FieldMetadata {
    @JsonProperty(value="required")
    private Boolean required;
    @JsonProperty(value="schema")
    private JsonTypeBean schema;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="autoCompleteUrl")
    private String autoCompleteUrl;
    @JsonProperty(value="hasDefaultValue")
    private Boolean hasDefaultValue;
    @JsonProperty(value="operations")
    private List<String> operations = new ArrayList<String>();
    @JsonProperty(value="allowedValues")
    private List<Object> allowedValues = new ArrayList<Object>();
    @JsonProperty(value="defaultValue")
    private Object defaultValue = null;

    @ApiModelProperty(required=true, value="Indicates whether the field is required.")
    public Boolean getRequired() {
        return this.required;
    }

    @ApiModelProperty(value="The data type of the field.")
    public JsonTypeBean getSchema() {
        return this.schema;
    }

    @ApiModelProperty(required=true, value="The name of the field.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(required=true, value="The key of the field.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="The URL that can be used to automatically complete the field.")
    public String getAutoCompleteUrl() {
        return this.autoCompleteUrl;
    }

    @ApiModelProperty(value="Indicates whether the field has a default value.")
    public Boolean getHasDefaultValue() {
        return this.hasDefaultValue;
    }

    @ApiModelProperty(required=true, value="The list of operations that can be performed on the field.")
    public List<String> getOperations() {
        return this.operations;
    }

    @ApiModelProperty(value="The list of values allowed in the field.")
    public List<Object> getAllowedValues() {
        return this.allowedValues;
    }

    @ApiModelProperty(value="The default value of the field.")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMetadata fieldMetadata = (FieldMetadata)o;
        return Objects.equals(this.required, fieldMetadata.required) && Objects.equals(this.schema, fieldMetadata.schema) && Objects.equals(this.name, fieldMetadata.name) && Objects.equals(this.key, fieldMetadata.key) && Objects.equals(this.autoCompleteUrl, fieldMetadata.autoCompleteUrl) && Objects.equals(this.hasDefaultValue, fieldMetadata.hasDefaultValue) && Objects.equals(this.operations, fieldMetadata.operations) && Objects.equals(this.allowedValues, fieldMetadata.allowedValues) && Objects.equals(this.defaultValue, fieldMetadata.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.required, this.schema, this.name, this.key, this.autoCompleteUrl, this.hasDefaultValue, this.operations, this.allowedValues, this.defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldMetadata {\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    autoCompleteUrl: ").append(this.toIndentedString(this.autoCompleteUrl)).append("\n");
        sb.append("    hasDefaultValue: ").append(this.toIndentedString(this.hasDefaultValue)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    allowedValues: ").append(this.toIndentedString(this.allowedValues)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

