/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.everit.atlassian.restclient.jiracloud.v3.model.ColumnItem;
import org.everit.atlassian.restclient.jiracloud.v3.model.FoundUsers;
import org.everit.atlassian.restclient.jiracloud.v3.model.GroupName;
import org.everit.atlassian.restclient.jiracloud.v3.model.User;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserWriteBean;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestClientUtil;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class UserApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<User> returnType_createUser = new TypeReference<User>(){};
    private static final TypeReference<List<User>> returnType_findAssignableUsers = new TypeReference<List<User>>(){};
    private static final TypeReference<List<User>> returnType_findBulkAssignableUsers = new TypeReference<List<User>>(){};
    private static final TypeReference<List<User>> returnType_findUsers = new TypeReference<List<User>>(){};
    private static final TypeReference<FoundUsers> returnType_findUsersForPicker = new TypeReference<FoundUsers>(){};
    private static final TypeReference<List<User>> returnType_findUsersWithAllPermissions = new TypeReference<List<User>>(){};
    private static final TypeReference<List<User>> returnType_findUsersWithBrowsePermission = new TypeReference<List<User>>(){};
    private static final TypeReference<User> returnType_getUser = new TypeReference<User>(){};
    private static final TypeReference<List<ColumnItem>> returnType_getUserDefaultColumns = new TypeReference<List<ColumnItem>>(){};
    private static final TypeReference<List<GroupName>> returnType_getUserGroups = new TypeReference<List<GroupName>>(){};
    private static final TypeReference<Object> returnType_setUserColumns = new TypeReference<Object>(){};
    private final RestClient restClient;

    public UserApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Single<User> createUser(UserWriteBean requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.POST).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(requestBody));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_createUser);
    }

    public Single<List<User>> findAssignableUsers(Optional<String> query, Optional<String> sessionId, Optional<String> username, Optional<String> accountId, Optional<String> project, Optional<String> issueKey, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<Integer> actionDescriptorId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/assignable/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (sessionId.isPresent()) {
            queryParams.put("sessionId", Collections.singleton(String.valueOf(sessionId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (project.isPresent()) {
            queryParams.put("project", Collections.singleton(String.valueOf(project.get())));
        }
        if (issueKey.isPresent()) {
            queryParams.put("issueKey", Collections.singleton(String.valueOf(issueKey.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (actionDescriptorId.isPresent()) {
            queryParams.put("actionDescriptorId", Collections.singleton(String.valueOf(actionDescriptorId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findAssignableUsers);
    }

    public Single<List<User>> findBulkAssignableUsers(Optional<String> query, Optional<String> username, Optional<String> accountId, Optional<String> projectKeys, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/assignable/multiProjectSearch");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (projectKeys.isPresent()) {
            queryParams.put("projectKeys", Collections.singleton(String.valueOf(projectKeys.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findBulkAssignableUsers);
    }

    public Single<List<User>> findUsers(Optional<String> query, Optional<String> username, Optional<String> accountId, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<String> property, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (property.isPresent()) {
            queryParams.put("property", Collections.singleton(String.valueOf(property.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findUsers);
    }

    public Single<FoundUsers> findUsersForPicker(Optional<String> query, Optional<Integer> maxResults, Optional<Boolean> showAvatar, Optional<List<String>> exclude, Optional<List<String>> excludeAccountIds, Optional<String> avatarSize, Optional<Boolean> excludeConnectUsers, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/picker");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Collection> queryParams = new HashMap<String, Collection>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        if (showAvatar.isPresent()) {
            queryParams.put("showAvatar", Collections.singleton(String.valueOf(showAvatar.get())));
        }
        if (exclude.isPresent()) {
            queryParams.put("exclude", RestClientUtil.objectCollectionToStringCollection((Collection)exclude.get()));
        }
        if (excludeAccountIds.isPresent()) {
            queryParams.put("excludeAccountIds", RestClientUtil.objectCollectionToStringCollection((Collection)excludeAccountIds.get()));
        }
        if (avatarSize.isPresent()) {
            queryParams.put("avatarSize", Collections.singleton(String.valueOf(avatarSize.get())));
        }
        if (excludeConnectUsers.isPresent()) {
            queryParams.put("excludeConnectUsers", Collections.singleton(String.valueOf(excludeConnectUsers.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findUsersForPicker);
    }

    public Single<List<User>> findUsersWithAllPermissions(Optional<String> query, Optional<String> username, Optional<String> accountId, Optional<String> permissions, Optional<String> issueKey, Optional<String> projectKey, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/permission/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (permissions.isPresent()) {
            queryParams.put("permissions", Collections.singleton(String.valueOf(permissions.get())));
        }
        if (issueKey.isPresent()) {
            queryParams.put("issueKey", Collections.singleton(String.valueOf(issueKey.get())));
        }
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findUsersWithAllPermissions);
    }

    public Single<List<User>> findUsersWithBrowsePermission(Optional<String> query, Optional<String> username, Optional<String> accountId, Optional<String> issueKey, Optional<String> projectKey, Optional<Integer> startAt, Optional<Integer> maxResults, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/viewissue/search");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (query.isPresent()) {
            queryParams.put("query", Collections.singleton(String.valueOf(query.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (issueKey.isPresent()) {
            queryParams.put("issueKey", Collections.singleton(String.valueOf(issueKey.get())));
        }
        if (projectKey.isPresent()) {
            queryParams.put("projectKey", Collections.singleton(String.valueOf(projectKey.get())));
        }
        if (startAt.isPresent()) {
            queryParams.put("startAt", Collections.singleton(String.valueOf(startAt.get())));
        }
        if (maxResults.isPresent()) {
            queryParams.put("maxResults", Collections.singleton(String.valueOf(maxResults.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_findUsersWithBrowsePermission);
    }

    public Single<User> getUser(Optional<String> accountId, Optional<String> username, Optional<String> key, Optional<String> expand, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (key.isPresent()) {
            queryParams.put("key", Collections.singleton(String.valueOf(key.get())));
        }
        if (expand.isPresent()) {
            queryParams.put("expand", Collections.singleton(String.valueOf(expand.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUser);
    }

    public Single<List<ColumnItem>> getUserDefaultColumns(Optional<String> accountId, Optional<String> username, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/columns");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUserDefaultColumns);
    }

    public Single<List<GroupName>> getUserGroups(Optional<String> accountId, Optional<String> username, Optional<String> key, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/groups");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (key.isPresent()) {
            queryParams.put("key", Collections.singleton(String.valueOf(key.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getUserGroups);
    }

    public Completable removeUser(Optional<String> accountId, Optional<String> username, Optional<String> key, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        if (key.isPresent()) {
            queryParams.put("key", Collections.singleton(String.valueOf(key.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Completable resetUserColumns(Optional<String> accountId, Optional<String> username, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/columns");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        if (username.isPresent()) {
            queryParams.put("username", Collections.singleton(String.valueOf(username.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<Object> setUserColumns(Optional<String> accountId, Optional<List<String>> requestBody, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/user/columns");
        HashMap pathParams = new HashMap();
        requestBuilder.pathParams(pathParams);
        HashMap<String, Set<String>> queryParams = new HashMap<String, Set<String>>();
        if (accountId.isPresent()) {
            queryParams.put("accountId", Collections.singleton(String.valueOf(accountId.get())));
        }
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(requestBody);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setUserColumns);
    }
}

