/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.api;

import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.HashMap;
import java.util.Optional;
import org.everit.atlassian.restclient.jiracloud.v3.model.EntityProperty;
import org.everit.atlassian.restclient.jiracloud.v3.model.PropertyKeys;
import org.everit.http.client.HttpMethod;
import org.everit.http.restclient.RestClient;
import org.everit.http.restclient.RestRequest;
import org.everit.http.restclient.RestRequestEnhancer;
import org.everit.http.restclient.TypeReference;

public class DashboardItemPropertyApi {
    private static final String DEFAULT_BASE_PATH = "http://localhost";
    private static final TypeReference<EntityProperty> returnType_getDashboardItemProperty = new TypeReference<EntityProperty>(){};
    private static final TypeReference<PropertyKeys> returnType_getDashboardItemPropertyKeys = new TypeReference<PropertyKeys>(){};
    private static final TypeReference<Object> returnType_setDashboardItemProperty = new TypeReference<Object>(){};
    private final RestClient restClient;

    public DashboardItemPropertyApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public Completable deleteDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.DELETE).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer);
    }

    public Single<EntityProperty> getDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboardItemProperty);
    }

    public Single<PropertyKeys> getDashboardItemPropertyKeys(String dashboardId, String itemId, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.GET).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_getDashboardItemPropertyKeys);
    }

    public Single<Object> setDashboardItemProperty(String dashboardId, String itemId, String propertyKey, Object body, Optional<RestRequestEnhancer> restRequestEnhancer) {
        RestRequest.Builder requestBuilder = RestRequest.builder().method(HttpMethod.PUT).basePath(DEFAULT_BASE_PATH).path("/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}");
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("dashboardId", String.valueOf(dashboardId));
        pathParams.put("itemId", String.valueOf(itemId));
        pathParams.put("propertyKey", String.valueOf(propertyKey));
        requestBuilder.pathParams(pathParams);
        HashMap queryParams = new HashMap();
        requestBuilder.queryParams(queryParams);
        HashMap headers = new HashMap();
        requestBuilder.headers(headers);
        requestBuilder.requestBody(Optional.of(body));
        return this.restClient.callEndpoint(requestBuilder.build(), restRequestEnhancer, returnType_setDashboardItemProperty);
    }
}

