/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.RoleActor;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;

@ApiModel(description="Details about the roles in a project.")
public class ProjectRole {
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="actors")
    private List<RoleActor> actors = new ArrayList<RoleActor>();
    @JsonProperty(value="scope")
    private Scope scope;

    @ApiModelProperty(value="The URL the project role details.")
    public URI getSelf() {
        return this.self;
    }

    public ProjectRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the project role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The ID of the project role.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The description of the project role.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The list of users who act in this role.")
    public List<RoleActor> getActors() {
        return this.actors;
    }

    @ApiModelProperty(value="The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).")
    public Scope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectRole projectRole = (ProjectRole)o;
        return Objects.equals(this.self, projectRole.self) && Objects.equals(this.name, projectRole.name) && Objects.equals(this.id, projectRole.id) && Objects.equals(this.description, projectRole.description) && Objects.equals(this.actors, projectRole.actors) && Objects.equals(this.scope, projectRole.scope);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.name, this.id, this.description, this.actors, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectRole {\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    actors: ").append(this.toIndentedString(this.actors)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

