/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v2.model.PermissionGrant;
import org.everit.atlassian.restclient.jiracloud.v2.model.Scope;

@ApiModel(description="Details of a permission scheme.")
public class PermissionScheme {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="scope")
    private Scope scope;
    @JsonProperty(value="permissions")
    private List<PermissionGrant> permissions = new ArrayList<PermissionGrant>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    @ApiModelProperty(value="The expand options available for the permission scheme.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="The ID of the permission scheme.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL of the permission scheme.")
    public URI getSelf() {
        return this.self;
    }

    public PermissionScheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the permission scheme. Must be unique. Required when creating or updating a permission scheme.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PermissionScheme description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description for the permission scheme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PermissionScheme scope(Scope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="The scope of the permission scheme.")
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public PermissionScheme permissions(List<PermissionGrant> permissions) {
        this.permissions = permissions;
        return this;
    }

    public PermissionScheme addPermissionsItem(PermissionGrant permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionGrant>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="The permission scheme to create or update. See [About permission schemes and grants](#about-permission-schemes-and-grants) for more information.")
    public List<PermissionGrant> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<PermissionGrant> permissions) {
        this.permissions = permissions;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionScheme permissionScheme = (PermissionScheme)o;
        return Objects.equals(this.expand, permissionScheme.expand) && Objects.equals(this.id, permissionScheme.id) && Objects.equals(this.self, permissionScheme.self) && Objects.equals(this.name, permissionScheme.name) && Objects.equals(this.description, permissionScheme.description) && Objects.equals(this.scope, permissionScheme.scope) && Objects.equals(this.permissions, permissionScheme.permissions) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.id, this.self, this.name, this.description, this.scope, this.permissions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionScheme {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

